/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidfile;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.marketdesignresearch.mechlib.core.bidder.valuefunction.BundleValue;
import org.spectrumauctions.sats.core.bidfile.FileWriter;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;

public class CatsExporter
extends FileWriter {
    public CatsExporter(File path) {
        super(path);
    }

    @Override
    public File writeSingleBidderXOR(BiddingLanguage valueFunction, int numberOfBids, String filePrefix) throws IOException {
        Iterator<BundleValue> iter = valueFunction.iterator();
        HashSet<BundleValue> selectedValues = new HashSet<BundleValue>();
        List<String> bidLines = this.fileInit(valueFunction);
        for (int i = 0; i < numberOfBids && iter.hasNext(); ++i) {
            BundleValue value = iter.next();
            selectedValues.add(value);
            String sb = i + "\t" + value.getAmount().setScale(4, 4).toString() + "\t" + value.getBundle().toString().replace(",", "\t") + "#";
            bidLines.add(sb);
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("goods " + valueFunction.getBidder().getWorld().getNumberOfGoods());
        lines.add("bids " + selectedValues.size());
        lines.add("dummy 0");
        lines.add("");
        lines.addAll(bidLines);
        return this.write(lines, filePrefix);
    }

    private List<String> fileInit(BiddingLanguage lang) {
        ArrayList<String> lines = new ArrayList<String>();
        String satsversion = null;
        try {
            satsversion = this.getClass().getPackage().getImplementationVersion();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (satsversion == null) {
            satsversion = "(UNKNOWN VERSION)";
        }
        lines.add("%% File generated by SATS  ".concat(satsversion).concat("  on  ").concat(new Date().toString()));
        lines.add("");
        lines.add("%% The SATS webpage is http://spectrumauctions.org");
        lines.add("");
        return lines;
    }

    @Override
    public File writeMultiBidderXOR(Collection<BiddingLanguage> valueFunctions, int numberOfBids, String filePrefix) throws IOException {
        List<String> lines = this.fileInit(valueFunctions.iterator().next());
        lines.add("%% This file may contain bids from multiple bidders.");
        lines.add("% Bids from different bidders are separated using dummy items with negative IDs");
        lines.add("");
        lines.add("");
        ArrayList<String> bidLines = new ArrayList<String>();
        int dummyItem = -1;
        int countBids = 0;
        for (BiddingLanguage valueFunction : valueFunctions) {
            Iterator<BundleValue> iter = valueFunction.iterator();
            for (int i = 0; i < numberOfBids && iter.hasNext(); ++i) {
                BundleValue value = iter.next();
                StringBuilder line = new StringBuilder(String.valueOf(countBids++)).append("\t");
                line.append(value.getAmount().setScale(4, 4).toString());
                line.append("\t");
                line.append(value.getBundle().toString().replace(",", "\t"));
                line.append("\t");
                line.append(dummyItem);
                line.append("\t#");
                bidLines.add(line.toString());
            }
            --dummyItem;
        }
        lines.add("goods " + valueFunctions.iterator().next().getBidder().getWorld().getNumberOfGoods());
        lines.add("bids " + bidLines.size());
        lines.add("dummy " + valueFunctions.size());
        lines.add("");
        lines.addAll(bidLines);
        return this.write(lines, filePrefix);
    }

    private File write(List<String> lines, String filePrefix) throws IOException {
        Path file = this.nextNonexistingFile(filePrefix);
        Files.write(file, lines, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        return file.toFile();
    }

    @Override
    public File writeMultiBidderXORQ(Collection<BiddingLanguage> valueFunctions, int numberOfBids, String filePrefix) throws IOException {
        throw new UnsupportedOperationException("XOR-Q is not compatible with the CATS file format");
    }

    @Override
    public File writeSingleBidderXORQ(BiddingLanguage lang, int numberOfBids, String filePrefix) throws IOException {
        throw new UnsupportedOperationException("XOR-Q is not compatible with the CATS file format");
    }

    @Override
    protected String filetype() {
        return "txt";
    }
}

