/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidfile;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Iterator;
import org.marketdesignresearch.mechlib.core.BundleEntry;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.bidder.valuefunction.BundleValue;
import org.spectrumauctions.sats.core.bidfile.FileWriter;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.model.License;

public class JsonExporter
extends FileWriter {
    public static final boolean ONLY_NONZERO_QUANTITIES = true;
    Gson gson;

    public JsonExporter(File path) {
        super(path);
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        this.gson = builder.create();
    }

    @Override
    public File writeMultiBidderXOR(Collection<BiddingLanguage> valueFunctions, int numberOfBids, String filePrefix) throws IOException {
        JsonArray json = new JsonArray();
        for (BiddingLanguage lang : valueFunctions) {
            JsonObject thisBidder = new JsonObject();
            thisBidder.addProperty("bidder", (Number)lang.getBidder().getLongId());
            thisBidder.add("bids", this.singleBidderXOR(lang, numberOfBids, filePrefix));
            json.add((JsonElement)thisBidder);
        }
        return this.write((JsonElement)json, filePrefix);
    }

    private JsonElement singleBidderXOR(BiddingLanguage lang, int numberOfBids, String filePrefix) {
        JsonArray result = new JsonArray();
        Iterator<BundleValue> iter = lang.iterator();
        for (int i = 0; i < numberOfBids && iter.hasNext(); ++i) {
            JsonObject bid = new JsonObject();
            BundleValue xorValue = iter.next();
            JsonArray licenses = new JsonArray();
            for (Good license : xorValue.getBundle().getSingleQuantityGoods()) {
                License l = (License)license;
                licenses.add((Number)l.getLongId());
            }
            bid.add("licenses", (JsonElement)licenses);
            bid.addProperty("value", xorValue.getAmount().setScale(4, 4).toString());
            result.add((JsonElement)bid);
        }
        return result;
    }

    @Override
    public File writeSingleBidderXOR(BiddingLanguage valueFunction, int numberOfBids, String filePrefix) throws IOException {
        JsonElement singleBidder = this.singleBidderXOR(valueFunction, numberOfBids, filePrefix);
        return this.write(singleBidder, filePrefix);
    }

    @Override
    public File writeMultiBidderXORQ(Collection<BiddingLanguage> valueFunctions, int numberOfBids, String filePrefix) throws IOException {
        JsonArray json = new JsonArray();
        for (BiddingLanguage lang : valueFunctions) {
            JsonObject thisBidder = new JsonObject();
            thisBidder.addProperty("bidder", (Number)lang.getBidder().getLongId());
            thisBidder.add("bids", this.singleBidderXORQ(lang, numberOfBids, filePrefix));
            json.add((JsonElement)thisBidder);
        }
        return this.write((JsonElement)json, filePrefix);
    }

    @Override
    public File writeSingleBidderXORQ(BiddingLanguage lang, int numberOfBids, String filePrefix) throws IOException {
        JsonElement singleBidder = this.singleBidderXORQ(lang, numberOfBids, filePrefix);
        return this.write(singleBidder, filePrefix);
    }

    private JsonElement singleBidderXORQ(BiddingLanguage lang, int numberOfBids, String filePrefix) {
        JsonArray result = new JsonArray();
        Iterator<BundleValue> iter = lang.iterator();
        for (int i = 0; i < numberOfBids && iter.hasNext(); ++i) {
            JsonObject bid = new JsonObject();
            BundleValue val = iter.next();
            JsonArray quantities = new JsonArray();
            for (BundleEntry quant : val.getBundle().getBundleEntries()) {
                if (quant.getAmount() == 0) continue;
                GenericGood good = (GenericGood)quant.getGood();
                JsonObject object = new JsonObject();
                object.add("generic definition", good.shortJson());
                object.addProperty("quantity", (Number)quant.getAmount());
                quantities.add((JsonElement)object);
            }
            bid.add("quantities", (JsonElement)quantities);
            bid.addProperty("value", val.getAmount().setScale(4, 4).toString());
            result.add((JsonElement)bid);
        }
        return result;
    }

    private File write(JsonElement toWrite, String filePrefix) throws IOException {
        Path file = this.nextNonexistingFile(filePrefix);
        String content = this.gson.toJson(toWrite);
        Files.write(file, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
        return file.toFile();
    }

    @Override
    protected String filetype() {
        return "json";
    }
}

