/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.BundleEntry;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.bidder.valuefunction.BundleValue;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeOrdered;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;

public abstract class GenericSizeDecreasing
extends GenericSizeOrdered {
    protected GenericSizeDecreasing(Collection<? extends GenericGood> allPossibleGenericDefintions) throws UnsupportedBiddingLanguageException {
        super(allPossibleGenericDefintions);
    }

    @Override
    public Iterator<BundleValue> iterator() {
        return new DecreasingIterator();
    }

    private class DecreasingIterator
    implements Iterator<BundleValue> {
        int round = 0;
        private Iterator<Set<GenericGood>> definitionPowersetIterator;
        private Map<GenericGood, Integer> roundSize;
        private boolean hasNext;

        protected DecreasingIterator() {
            this.initNextRound();
        }

        private void initNextRound() {
            this.roundSize = new HashMap<GenericGood, Integer>();
            for (GenericGood good : GenericSizeDecreasing.this.allGoods) {
                int quantity = good.getQuantity() - this.round;
                if (quantity < 0) {
                    quantity = 0;
                }
                this.roundSize.put(good, quantity);
            }
            ++this.round;
            this.initPowersetIterator();
        }

        private void initPowersetIterator() {
            HashSet<GenericGood> leftOverQuantities = new HashSet<GenericGood>();
            for (GenericGood good : GenericSizeDecreasing.this.allGoods) {
                if (this.roundSize.get(good) <= 0) continue;
                leftOverQuantities.add(good);
            }
            if (leftOverQuantities.size() == 0) {
                this.hasNext = false;
                return;
            }
            this.hasNext = true;
            Set definitionPowerset = Sets.powerSet(leftOverQuantities);
            ArrayList<Set<GenericGood>> sorted = new ArrayList<Set<GenericGood>>(definitionPowerset);
            sorted.sort(GenericSizeDecreasing.this.getIncreasingSizeComparator());
            this.definitionPowersetIterator = sorted.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public BundleValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            HashSet<BundleEntry> bundleEntries = new HashSet<BundleEntry>();
            Set<GenericGood> toSubstract = this.definitionPowersetIterator.next();
            for (GenericGood good : GenericSizeDecreasing.this.allGoods) {
                int quantity = this.roundSize.get(good);
                if (toSubstract.contains(good)) {
                    --quantity;
                }
                if (quantity <= 0) continue;
                bundleEntries.add(new BundleEntry((Good)good, quantity));
            }
            if (!this.definitionPowersetIterator.hasNext()) {
                this.initNextRound();
            }
            Bundle bundle = new Bundle(bundleEntries);
            return new BundleValue(GenericSizeDecreasing.this.getBidder().calculateValue(bundle), bundle);
        }
    }
}

