/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.generic.SimpleRandomOrder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.BundleEntry;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.bidder.valuefunction.BundleValue;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public abstract class XORQRandomOrderSimple
implements BiddingLanguage {
    private static final double MAX_POSSIBLE_BIDS_FACTOR = 0.8;
    private static final int ABSOLUTE_MAX_BIDS = 1000000;
    private static final int DEFAULT_ITERATIONS = 500;
    private final int maxBundleSize;
    private final RNGSupplier rngSupplier;
    private final List<? extends GenericGood> genericGoods;
    private final transient int totalSize;
    private final transient Set<BundleValue> cache;
    private final transient int maxBids;
    private transient int iterations;

    protected XORQRandomOrderSimple(List<? extends GenericGood> genericGoods, RNGSupplier rngSupplier) {
        int quantitySum;
        this.genericGoods = genericGoods;
        this.rngSupplier = rngSupplier;
        this.maxBundleSize = quantitySum = genericGoods.stream().mapToInt(GenericGood::getQuantity).sum();
        this.totalSize = quantitySum;
        this.iterations = 500;
        this.maxBids = this.setMaxBid();
        this.cache = new HashSet<BundleValue>();
    }

    private int setMaxBid() {
        int maxBids = 1;
        for (GenericGood genericGood : this.genericGoods) {
            if (Math.abs(maxBids) > 1000000) break;
            maxBids *= genericGood.getQuantity();
        }
        return maxBids;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public Iterator<BundleValue> iterator() {
        return new SimpleRandomOrderIterator(this.iterations, this.rngSupplier.getUniformDistributionRNG());
    }

    class SimpleRandomOrderIterator
    implements Iterator<BundleValue> {
        private final UniformDistributionRNG uniRng;
        private int remainingIterations;

        SimpleRandomOrderIterator(int iterations, UniformDistributionRNG uniRng) {
            this.remainingIterations = iterations;
            this.uniRng = uniRng;
        }

        @Override
        public boolean hasNext() {
            return this.remainingIterations > 0 && (double)XORQRandomOrderSimple.this.cache.size() < 0.8 * (double)XORQRandomOrderSimple.this.maxBids;
        }

        @Override
        public BundleValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map<GenericGood, Integer> quantities = this.getRandomQuantities();
            HashSet<BundleEntry> bundleEntries = new HashSet<BundleEntry>();
            for (Map.Entry<GenericGood, Integer> entry : quantities.entrySet()) {
                bundleEntries.add(new BundleEntry((Good)entry.getKey(), entry.getValue().intValue()));
            }
            Bundle bundle = new Bundle(bundleEntries);
            BundleValue result = new BundleValue(XORQRandomOrderSimple.this.getBidder().calculateValue(bundle), bundle);
            if (!XORQRandomOrderSimple.this.cache.contains(result)) {
                XORQRandomOrderSimple.this.cache.add(result);
                --this.remainingIterations;
                return result;
            }
            return this.next();
        }

        private Map<GenericGood, Integer> getRandomQuantities() {
            HashMap<GenericGood, Integer> quantities = new HashMap<GenericGood, Integer>();
            for (GenericGood genericGood : XORQRandomOrderSimple.this.genericGoods) {
                if (!this.includeGood(genericGood.getQuantity(), XORQRandomOrderSimple.this.totalSize, XORQRandomOrderSimple.this.genericGoods.size())) continue;
                int quantity = this.uniRng.nextInt(1, genericGood.getQuantity());
                quantities.put(genericGood, quantity);
            }
            return quantities;
        }

        private boolean includeGood(int quantity, int totalQuantity, int numberOfGoods) {
            double base = 1.0 / (double)numberOfGoods;
            double bonus = 1.0 / (double)totalQuantity * (double)quantity;
            return base + bonus >= this.uniRng.nextDouble();
        }
    }
}

