/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.xor;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.BundleEntry;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.bidder.valuefunction.BundleValue;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.model.cats.CATSBidder;
import org.spectrumauctions.sats.core.model.cats.CATSLicense;
import org.spectrumauctions.sats.core.model.cats.CATSWorld;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public class CatsXOR
implements BiddingLanguage {
    private static final Logger logger = LogManager.getLogger(CatsXOR.class);
    private Collection<CATSLicense> goods;
    private CATSBidder bidder;
    private RNGSupplier rngSupplier;
    private CATSWorld world;
    private boolean noCapForSubstitutableGoods;

    public CatsXOR(Collection<CATSLicense> goods, RNGSupplier rngSupplier, CATSBidder bidder) {
        this.goods = goods;
        this.bidder = bidder;
        this.rngSupplier = rngSupplier;
        this.world = goods.stream().findAny().orElseThrow(() -> new IllegalArgumentException("All passed goods must have a world")).getWorld();
        this.noCapForSubstitutableGoods = false;
    }

    public CatsXOR noCapForSubstitutableGoods() {
        this.noCapForSubstitutableGoods = true;
        return this;
    }

    @Override
    public CATSBidder getBidder() {
        return this.bidder;
    }

    @Override
    public Iterator<BundleValue> iterator() {
        if (this.noCapForSubstitutableGoods) {
            return new CATSIterator(this.rngSupplier.getUniformDistributionRNG(), false);
        }
        return this.getCATSXORBids().iterator();
    }

    public Set<BundleValue> getCATSXORBids() {
        TreeSet<BundleValue> sortedSet = new TreeSet<BundleValue>();
        HashSet<BundleValue> result = new HashSet<BundleValue>();
        CATSIterator iterator = new CATSIterator(this.rngSupplier.getUniformDistributionRNG(), true);
        result.add((BundleValue)iterator.next());
        while (iterator.hasNext()) {
            BundleValue next = (BundleValue)iterator.next();
            if (next == null) continue;
            sortedSet.add(next);
        }
        for (int i = 0; i < this.world.getMaxSubstitutableBids() && !sortedSet.isEmpty(); ++i) {
            BundleValue val = (BundleValue)sortedSet.first();
            if (!result.stream().map(BundleValue::getBundle).collect(Collectors.toList()).contains(val.getBundle())) {
                result.add(val);
            }
            sortedSet.remove(val);
        }
        return result;
    }

    private class WeightedRandomCollection<T>
    implements Iterator<T> {
        private final NavigableMap<Double, T> map = new TreeMap<Double, T>();
        private final UniformDistributionRNG random;
        private double total = 0.0;

        private WeightedRandomCollection(UniformDistributionRNG random) {
            this.random = random;
        }

        public void add(double weight, T result) {
            this.total += weight;
            this.map.put(this.total, result);
        }

        @Override
        public boolean hasNext() {
            return !this.map.isEmpty();
        }

        @Override
        public T next() {
            double value = this.random.nextDouble() * this.total;
            Map.Entry<Double, T> entry = this.map.ceilingEntry(value);
            if (entry == null) {
                return null;
            }
            return entry.getValue();
        }
    }

    private class CATSIterator
    implements Iterator<BundleValue> {
        private static final int MAX_RETRIES = 100;
        private final UniformDistributionRNG uniRng;
        private Queue<CATSLicense> originalLicenseQueue;
        private Set<CATSLicense> originalBundle;
        private double minValue;
        private double budget;
        private double minResaleValue;
        private int retries;
        private boolean acceptNulls;

        CATSIterator(UniformDistributionRNG uniRng, boolean acceptNulls) {
            Preconditions.checkArgument((CatsXOR.this.world.getLicenses().size() == CatsXOR.this.goods.size() ? 1 : 0) != 0);
            this.uniRng = uniRng;
            this.minValue = 1.0E10;
            this.retries = 0;
            this.acceptNulls = acceptNulls;
        }

        @Override
        public boolean hasNext() {
            if (this.originalBundle == null) {
                return true;
            }
            int licensesLeftToChoose = CatsXOR.this.goods.size() - this.originalBundle.size();
            return this.originalBundle.size() > 1 && !this.originalLicenseQueue.isEmpty() && licensesLeftToChoose > 0 && this.retries < 100;
        }

        @Override
        public BundleValue next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            HashSet<CATSLicense> licenses = new HashSet<CATSLicense>();
            for (Map.Entry entry : CatsXOR.this.bidder.getPrivateValues().entrySet()) {
                if (!(((BigDecimal)entry.getValue()).doubleValue() < this.minValue)) continue;
                this.minValue = ((BigDecimal)entry.getValue()).doubleValue();
            }
            if (this.originalLicenseQueue == null) {
                WeightedRandomCollection weightedGoods = new WeightedRandomCollection(this.uniRng);
                CatsXOR.this.goods.forEach(g -> {
                    double positivePrivateValue = ((BigDecimal)CatsXOR.this.bidder.getPrivateValues().get((Object)g.getLongId())).doubleValue() - this.minValue;
                    weightedGoods.add(positivePrivateValue, g);
                });
                CATSLicense first = (CATSLicense)weightedGoods.next();
                licenses.add(first);
                while (licenses.size() < CatsXOR.this.goods.size() && this.uniRng.nextDouble() <= CatsXOR.this.world.getAdditionalLocation()) {
                    CATSLicense next = this.selectLicenseToAdd(licenses);
                    licenses.add(next);
                }
                Set bundleEntries = licenses.stream().map(l -> new BundleEntry((Good)l, 1)).collect(Collectors.toSet());
                Bundle bundle = new Bundle(bundleEntries);
                BigDecimal value = CatsXOR.this.bidder.calculateValue(bundle);
                if (value.compareTo(BigDecimal.ZERO) < 0) {
                    return this.next();
                }
                this.budget = CatsXOR.this.world.getBudgetFactor() * value.doubleValue();
                this.minResaleValue = CatsXOR.this.world.getResaleFactor() * licenses.stream().mapToDouble(CATSLicense::getCommonValue).sum();
                this.originalLicenseQueue = new LinkedBlockingQueue<CATSLicense>(licenses);
                this.originalBundle = licenses;
                return new BundleValue(value, bundle);
            }
            CATSLicense first = this.originalLicenseQueue.poll();
            licenses.add(first);
            while (licenses.size() < this.originalBundle.size()) {
                CATSLicense toAdd = this.selectLicenseToAdd(licenses);
                if (toAdd == null) continue;
                licenses.add(toAdd);
            }
            HashSet bundleEntries = (HashSet)licenses.stream().map(l -> new BundleEntry((Good)l, 1)).collect(Collectors.toSet());
            Bundle bundle = new Bundle((Set)bundleEntries);
            BigDecimal value = CatsXOR.this.bidder.calculateValue(bundle);
            double resaleValue = licenses.stream().mapToDouble(CATSLicense::getCommonValue).sum();
            if (value.doubleValue() >= 0.0 && value.doubleValue() <= this.budget && resaleValue >= this.minResaleValue && !licenses.equals(this.originalBundle)) {
                this.retries = 0;
                return new BundleValue(value, bundle);
            }
            try {
                return this.handleNulls(first);
            }
            catch (NoValidElementFoundException e) {
                logger.error((Object)e);
                logger.error("Returning null.");
                return null;
            }
        }

        private BundleValue handleNulls(CATSLicense first) throws NoValidElementFoundException {
            if (this.acceptNulls) {
                return null;
            }
            this.originalLicenseQueue.add(first);
            if (this.hasNext() && ++this.retries < 100) {
                return this.next();
            }
            throw new NoValidElementFoundException();
        }

        private CATSLicense selectLicenseToAdd(Set<CATSLicense> bundle) {
            if (this.uniRng.nextDouble() <= CatsXOR.this.world.getJumpProbability()) {
                Iterator<CATSLicense> iterator;
                CATSLicense randomLicense;
                if (CatsXOR.this.goods.size() == bundle.size()) {
                    return null;
                }
                do {
                    iterator = CatsXOR.this.goods.iterator();
                    int index = this.uniRng.nextInt(CatsXOR.this.goods.size());
                    for (int i = 0; i < index; ++i) {
                        iterator.next();
                    }
                } while (bundle.contains(randomLicense = iterator.next()));
                return randomLicense;
            }
            WeightedRandomCollection neighbors = new WeightedRandomCollection(this.uniRng);
            CatsXOR.this.goods.stream().filter(l -> !bundle.contains(l) && this.edgeExists((CATSLicense)l, bundle)).forEach(g -> {
                double positivePrivateValue = ((BigDecimal)CatsXOR.this.bidder.getPrivateValues().get((Object)g.getLongId())).doubleValue() - this.minValue;
                neighbors.add(positivePrivateValue, g);
            });
            if (neighbors.hasNext()) {
                return (CATSLicense)neighbors.next();
            }
            return null;
        }

        private boolean edgeExists(CATSLicense license, Set<CATSLicense> bundle) {
            for (CATSLicense l : bundle) {
                if (!CatsXOR.this.world.getGrid().isAdjacent(license.getVertex(), l.getVertex())) continue;
                return true;
            }
            return false;
        }

        private class NoValidElementFoundException
        extends Exception {
            NoValidElementFoundException() {
                super("After " + CATSIterator.this.retries + " retries, no other bundle was found that was not identical to the original bundle bid and is valid in terms of budget and min_resale_value constraints. \nMost likely, there are either almost no licenses to choose from or the original bundle is very small and highly valued, so that it's difficult to create another bundle that satisfies the constraints. Try again (maybe with a higher number of goods) or use the the iterator that handles this situation with null-values.");
            }
        }
    }
}

