/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.xor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.bidder.valuefunction.BundleValue;
import org.spectrumauctions.sats.core.bidlang.xor.SizeOrderedXOR;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.SATSBidder;

public class DecreasingSizeOrderedXOR
extends SizeOrderedXOR {
    public DecreasingSizeOrderedXOR(Collection<? extends License> goods, SATSBidder bidder) {
        super(goods, bidder);
    }

    @Override
    public Iterator<BundleValue> iterator() {
        return new DecreasingIterator();
    }

    private class DecreasingIterator
    implements Iterator<BundleValue> {
        BigInteger minIndex = BigInteger.ZERO;
        BigInteger index;

        private DecreasingIterator() {
            this.index = BigInteger.valueOf(2L).pow(DecreasingSizeOrderedXOR.this.goods.size()).subtract(BigInteger.ONE);
        }

        @Override
        public boolean hasNext() {
            return this.index.compareTo(this.minIndex) > 0;
        }

        @Override
        public BundleValue next() {
            Bundle bundle = DecreasingSizeOrderedXOR.this.getBundle(this.index);
            this.index = this.index.subtract(BigInteger.ONE);
            return new BundleValue(DecreasingSizeOrderedXOR.this.getBidder().calculateValue(bundle), bundle);
        }
    }
}

