/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.xor;

import com.google.common.math.BigIntegerMath;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.bidder.valuefunction.BundleValue;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.xor.IncreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.util.random.GaussianDistributionRNG;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public class SizeBasedUniqueRandomXOR
implements BiddingLanguage {
    private int meanBundleSize = -1;
    private double standardDeviation = -1.0;
    private Collection<? extends License> goods;
    private long seed;
    private final RNGSupplier rngSupplier;
    private int iterations = -1;
    private SATSBidder bidder;

    public SizeBasedUniqueRandomXOR(Collection<? extends License> goods, RNGSupplier rngSupplier, SATSBidder bidder) {
        this.goods = goods;
        this.seed = rngSupplier.getUniformDistributionRNG().nextLong();
        this.rngSupplier = rngSupplier;
        this.bidder = bidder;
    }

    protected BigDecimal getValue(Bundle goods) {
        return this.bidder.calculateValue(goods);
    }

    @Override
    public SATSBidder getBidder() {
        return this.bidder;
    }

    public void setDefaultDistribution() {
        this.meanBundleSize = this.goods.size() / 2;
        this.standardDeviation = (double)this.meanBundleSize / 2.0;
    }

    public void setMaxIterations() {
        int exponent = this.goods.size() < 13 ? this.goods.size() : 13;
        this.iterations = (int)Math.pow(2.0, exponent) - 1;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public void setDistribution(int meanBundleSize, double standardDeviation) {
        this.meanBundleSize = meanBundleSize;
        this.standardDeviation = standardDeviation;
    }

    @Deprecated
    public void setDistribution(int meanBundleSize, double standardDeviation, int iterations) {
        this.meanBundleSize = meanBundleSize;
        this.standardDeviation = standardDeviation;
        this.iterations = iterations;
    }

    @Override
    public Iterator<BundleValue> iterator() {
        if (this.meanBundleSize < 0 || this.standardDeviation < 0.0) {
            this.setDefaultDistribution();
        }
        if (this.iterations < 0) {
            this.setMaxIterations();
        }
        return new ValueIterator(this.rngSupplier.getUniformDistributionRNG(this.seed), this.rngSupplier.getGaussianDistributionRNG(this.seed + 1L), this.meanBundleSize, this.standardDeviation, this.iterations);
    }

    private BigInteger randomBigInteger(BigInteger maxValue, long seed) {
        BigInteger random;
        Random rnd = new Random(seed);
        while ((random = new BigInteger(maxValue.bitLength(), rnd)).compareTo(maxValue) > 0) {
        }
        return random;
    }

    private class ValueIterator
    implements Iterator<BundleValue> {
        final Map<Integer, SortedSet<BigInteger>> generatedBundleNumbers = new HashMap<Integer, SortedSet<BigInteger>>();
        final List<BigInteger> remainingBundles;
        final int numberOfGoods;
        private final UniformDistributionRNG uniRng;
        private final GaussianDistributionRNG gaussRng;
        private final int meanBundleSize;
        private final double stdDeviation;
        private int remainingIterations;

        public ValueIterator(UniformDistributionRNG uniRng, GaussianDistributionRNG gaussRng, int meanBundleSize, double stdDeviation, int iterations) {
            this.uniRng = uniRng;
            this.gaussRng = gaussRng;
            this.meanBundleSize = meanBundleSize;
            this.stdDeviation = stdDeviation;
            this.remainingIterations = iterations;
            this.numberOfGoods = SizeBasedUniqueRandomXOR.this.goods.size();
            this.remainingBundles = new ArrayList<BigInteger>(this.numberOfGoods - 1);
            while (this.remainingBundles.size() < this.numberOfGoods - 1) {
                this.remainingBundles.add(BigInteger.ZERO);
            }
            for (int bundleSize = 1; bundleSize <= this.numberOfGoods; ++bundleSize) {
                this.generatedBundleNumbers.put(bundleSize, new TreeSet<BigInteger>(new BigIntegerComparator()));
                BigInteger numberOfBundles = BigIntegerMath.binomial((int)this.numberOfGoods, (int)bundleSize);
                this.remainingBundles.add(bundleSize - 1, numberOfBundles);
            }
        }

        @Override
        public boolean hasNext() {
            return this.remainingIterations > 0;
        }

        @Override
        public BundleValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.remainingIterations;
            return this.recNext();
        }

        private BundleValue recNext() {
            BigInteger previouslyGeneratedIndex;
            int bundleSize = (int)Math.round(this.gaussRng.nextGaussian(this.meanBundleSize, SizeBasedUniqueRandomXOR.this.standardDeviation));
            if (bundleSize < 1 || bundleSize > SizeBasedUniqueRandomXOR.this.goods.size()) {
                return this.recNext();
            }
            BigInteger remainingBundlesOfThisSize = this.remainingBundles.get(bundleSize - 1);
            if (remainingBundlesOfThisSize == null) {
                return this.recNext();
            }
            if (remainingBundlesOfThisSize.compareTo(BigInteger.ZERO) <= 0) {
                return this.recNext();
            }
            BigInteger bundleId = SizeBasedUniqueRandomXOR.this.randomBigInteger(remainingBundlesOfThisSize, this.uniRng.nextLong());
            Iterator iterator = this.generatedBundleNumbers.get(bundleSize).iterator();
            while (iterator.hasNext() && bundleId.compareTo(previouslyGeneratedIndex = (BigInteger)iterator.next()) >= 0) {
                bundleId = bundleId.add(BigInteger.ONE);
            }
            this.generatedBundleNumbers.get(bundleSize).add(bundleId);
            BigInteger newlyAvailable = this.remainingBundles.remove(bundleSize - 1).subtract(BigInteger.ONE);
            this.remainingBundles.add(bundleSize - 1, newlyAvailable);
            IncreasingSizeOrderedXOR sizeOrderedXOR = new IncreasingSizeOrderedXOR(SizeBasedUniqueRandomXOR.this.goods, SizeBasedUniqueRandomXOR.this.getBidder());
            Bundle bundle = sizeOrderedXOR.getBundle(bundleId, bundleSize);
            return new BundleValue(SizeBasedUniqueRandomXOR.this.bidder.calculateValue(bundle), bundle);
        }
    }

    private class BigIntegerComparator
    implements Comparator<BigInteger>,
    Serializable {
        private BigIntegerComparator() {
        }

        @Override
        public int compare(BigInteger o1, BigInteger o2) {
            return o1.compareTo(o2);
        }
    }
}

