/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.xor;

import com.google.common.math.BigIntegerMath;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.BundleEntry;
import org.marketdesignresearch.mechlib.core.Good;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.SATSBidder;

public abstract class SizeOrderedXOR
implements BiddingLanguage {
    private static final Logger logger = LogManager.getLogger(SizeOrderedXOR.class);
    final List<? extends License> goods;
    private SATSBidder bidder;

    protected SizeOrderedXOR(Collection<? extends License> goods, SATSBidder bidder) {
        this.goods = new ArrayList<License>(goods);
        this.bidder = bidder;
    }

    @Override
    public SATSBidder getBidder() {
        return this.bidder;
    }

    public Bundle getBundle(BigInteger index) {
        String bundleRepresentation = SizeOrderedXOR.packageRepresentation(index, this.goods.size()).toString();
        return this.getBundle(bundleRepresentation);
    }

    private Bundle getBundle(String bundleRepresentation) {
        HashSet<BundleEntry> result = new HashSet<BundleEntry>();
        for (int i = 0; i < bundleRepresentation.length(); ++i) {
            if (bundleRepresentation.charAt(i) != '1') continue;
            result.add(new BundleEntry((Good)this.goods.get(i), 1));
        }
        return new Bundle(result);
    }

    public Bundle getBundle(BigInteger subIndex, int size) {
        String binaryString = SizeOrderedXOR.recBinaryString(subIndex, this.goods.size(), size).toString();
        return this.getBundle(binaryString);
    }

    public static StringBuilder packageRepresentation(BigInteger index, int n) {
        SizeStarter foundSize = SizeOrderedXOR.bundleSize(index, n);
        BigInteger sizeBasedIndex = index.subtract(foundSize.sizeStart);
        return SizeOrderedXOR.recBinaryString(sizeBasedIndex, n, foundSize.size);
    }

    private static SizeStarter bundleSize(BigInteger index, int n) {
        BigInteger sum = BigInteger.ZERO;
        BigInteger previousSum = null;
        int size = 0;
        while (sum.compareTo(index) < 0) {
            if (++size > n) {
                throw new RuntimeException("Index to big for available number of items: index=" + index.toString());
            }
            BigInteger thisSizeBundles = BigIntegerMath.binomial((int)n, (int)size);
            previousSum = sum;
            sum = sum.add(thisSizeBundles);
        }
        return new SizeStarter(size, previousSum);
    }

    private static StringBuilder recBinaryString(BigInteger sizeBasedIndex, int n, int k) {
        if (n == 0) {
            return new StringBuilder();
        }
        if (k == 0) {
            return new StringBuilder("0").append((CharSequence)SizeOrderedXOR.recBinaryString(sizeBasedIndex, n - 1, 0));
        }
        BigInteger bin = BigIntegerMath.binomial((int)n, (int)k);
        BigInteger biggestOneStarterIndex = bin.multiply(BigInteger.valueOf(k)).divide(BigInteger.valueOf(n));
        if (sizeBasedIndex.compareTo(biggestOneStarterIndex) <= 0) {
            return new StringBuilder("1").append((CharSequence)SizeOrderedXOR.recBinaryString(sizeBasedIndex, n - 1, k - 1));
        }
        BigInteger newIndex = sizeBasedIndex.subtract(biggestOneStarterIndex);
        if (n == k) {
            logger.warn("Problem!!!" + newIndex.toString() + " " + n + " " + k);
        }
        return new StringBuilder("0").append((CharSequence)SizeOrderedXOR.recBinaryString(newIndex, n - 1, k));
    }

    private static class SizeStarter {
        private final BigInteger sizeStart;
        private final int size;

        public SizeStarter(int size, BigInteger sizeStart) {
            this.sizeStart = sizeStart;
            this.size = size;
        }
    }
}

