/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.SATSGood;
import org.spectrumauctions.sats.core.model.World;

public abstract class GenericGood
implements SATSGood,
Serializable {
    private final UUID uuid = UUID.randomUUID();
    private final String name;
    protected final long worldId;
    private static final long serialVersionUID = 1345L;

    protected GenericGood(String name, long worldId) {
        this.name = name;
        this.worldId = worldId;
    }

    @Override
    public abstract World getWorld();

    public abstract List<? extends License> containedGoods();

    public int getQuantity() {
        return this.containedGoods().size();
    }

    public long getWorldId() {
        return this.worldId;
    }

    public JsonElement shortJson() {
        JsonObject json = new JsonObject();
        json.addProperty("good", this.getName());
        return json;
    }

    public String toString() {
        return "GenericGood(name=" + this.getName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericGood)) {
            return false;
        }
        GenericGood other = (GenericGood)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericGood;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }
}

