/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.model.GenericWorld;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.bvm.BMBand;
import org.spectrumauctions.sats.core.model.bvm.BMBidder;
import org.spectrumauctions.sats.core.model.bvm.BMBidderSetup;
import org.spectrumauctions.sats.core.model.bvm.BMLicense;
import org.spectrumauctions.sats.core.model.bvm.BMWorldSetup;
import org.spectrumauctions.sats.core.util.PreconditionUtils;
import org.spectrumauctions.sats.core.util.instancehandling.InstanceHandler;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public final class BMWorld
extends World
implements GenericWorld {
    public static final String MODEL_NAME = "Base and MultiBand Value Model";
    private static final long serialVersionUID = 8418773596929829197L;
    private final List<BMBand> bands;

    public BMWorld(BMWorldSetup setup, RNGSupplier rngSupplier) {
        super(MODEL_NAME);
        PreconditionUtils.checkNotNull(setup, rngSupplier);
        this.bands = this.createBands(setup, rngSupplier);
        this.store();
    }

    private List<BMBand> createBands(BMWorldSetup setup, RNGSupplier rngSupplier) {
        ArrayList<BMBand> bands = new ArrayList<BMBand>();
        int licenseCount = 0;
        for (Map.Entry<String, Integer> entry : setup.bands().entrySet()) {
            bands.add(new BMBand(this, entry.getKey(), entry.getValue(), licenseCount, rngSupplier));
            licenseCount += entry.getValue().intValue();
        }
        return bands;
    }

    public BMBand getBand(String bandName) {
        for (BMBand band : this.bands) {
            if (!band.getName().equals(bandName)) continue;
            return band;
        }
        return null;
    }

    public List<BMBand> getBands() {
        return Collections.unmodifiableList(this.bands);
    }

    public List<BMLicense> getLicenses() {
        LinkedList<BMLicense> licenses = new LinkedList<BMLicense>();
        for (BMBand band : this.bands) {
            licenses.addAll(band.containedGoods());
        }
        return licenses;
    }

    @Override
    public int getNumberOfGoods() {
        return this.getLicenses().size();
    }

    public List<BMBidder> createPopulation(BMBidderSetup bidderSetup) {
        return this.createPopulation(bidderSetup, (RNGSupplier)new JavaUtilRNGSupplier());
    }

    public List<BMBidder> createPopulation(BMBidderSetup bidderSetup, long seed) {
        return this.createPopulation(bidderSetup, (RNGSupplier)new JavaUtilRNGSupplier(seed));
    }

    public List<BMBidder> createPopulation(BMBidderSetup bidderSetup, RNGSupplier rngSupplier) {
        Preconditions.checkNotNull((Object)bidderSetup);
        HashSet<BMBidderSetup> setups = new HashSet<BMBidderSetup>();
        setups.add(bidderSetup);
        return this.createPopulation(setups, rngSupplier);
    }

    public List<BMBidder> createPopulation(Collection<BMBidderSetup> bidderSetups) {
        Preconditions.checkNotNull(bidderSetups);
        return this.createPopulation(bidderSetups, (RNGSupplier)new JavaUtilRNGSupplier());
    }

    public List<BMBidder> createPopulation(Collection<BMBidderSetup> bidderSetups, long seed) {
        return this.createPopulation(bidderSetups, (RNGSupplier)new JavaUtilRNGSupplier(seed));
    }

    public List<BMBidder> createPopulation(Collection<BMBidderSetup> bidderSetups, RNGSupplier rngSupplier) {
        long population = this.openNewPopulation();
        ArrayList<BMBidder> bidders = new ArrayList<BMBidder>();
        int idCount = 0;
        for (BMBidderSetup setup : bidderSetups) {
            for (int i = 0; i < setup.getNumberOfBidders(); ++i) {
                bidders.add(new BMBidder(population, idCount++, this, setup, rngSupplier.getUniformDistributionRNG()));
            }
        }
        return bidders;
    }

    public static BMWorld readWorld(long worldId) {
        return InstanceHandler.getDefaultHandler().readWorld(BMWorld.class, worldId);
    }

    @Override
    public void refreshFieldBackReferences() {
        for (BMBand band : this.bands) {
            band.refreshFieldBackReferences(this);
        }
    }

    public List<BMBidder> restorePopulation(long populationId) {
        return super.restorePopulation(BMBidder.class, populationId);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bands == null ? 0 : this.bands.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BMWorld other = (BMWorld)obj;
        return !(this.bands == null ? other.bands != null : !this.bands.equals(other.bands));
    }

    @Override
    public List<? extends GenericGood> getAllGenericDefinitions() {
        return this.bands;
    }
}

