/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeIncreasing;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeOrdered;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.bvm.BMBand;
import org.spectrumauctions.sats.core.model.bvm.BMBidder;

public class SizeOrderedGenericFactory
implements Serializable {
    private static final long serialVersionUID = -6233538112013604627L;
    static BandComparator comparator = new BandComparator();

    public static GenericSizeOrdered getSizeOrderedGenericLang(boolean increasing, BMBidder bidder) throws UnsupportedBiddingLanguageException {
        List<BMBand> bands = bidder.getWorld().getBands();
        if (increasing) {
            return new Increasing(bands, bidder);
        }
        return new Decreasing(bands, bidder);
    }

    private static class BandComparator
    implements Comparator<GenericGood>,
    Serializable {
        private static final long serialVersionUID = 5747471569466164302L;

        private BandComparator() {
        }

        @Override
        public int compare(GenericGood o1, GenericGood o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static final class Decreasing
    extends GenericSizeDecreasing {
        private final BMBidder bidder;

        protected Decreasing(Collection<BMBand> allPossibleGenericDefintions, BMBidder bidder) throws UnsupportedBiddingLanguageException {
            super(allPossibleGenericDefintions);
            this.bidder = bidder;
        }

        @Override
        public SATSBidder getBidder() {
            return this.bidder;
        }

        @Override
        protected Comparator<GenericGood> getDefComparator() {
            return comparator;
        }
    }

    private static final class Increasing
    extends GenericSizeIncreasing {
        private final BMBidder bidder;

        protected Increasing(List<BMBand> allPossibleGenericDefintions, BMBidder bidder) throws UnsupportedBiddingLanguageException {
            super(allPossibleGenericDefintions);
            this.bidder = bidder;
        }

        @Override
        public SATSBidder getBidder() {
            return this.bidder;
        }

        @Override
        protected Comparator<GenericGood> getDefComparator() {
            return comparator;
        }
    }
}

