/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.cats;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.NotImplementedException;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.price.Prices;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.xor.CatsXOR;
import org.spectrumauctions.sats.core.bidlang.xor.DecreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.IncreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.SizeBasedUniqueRandomXOR;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.cats.CATSBidderSetup;
import org.spectrumauctions.sats.core.model.cats.CATSLicense;
import org.spectrumauctions.sats.core.model.cats.CATSWorld;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public final class CATSBidder
extends SATSBidder {
    private static final long serialVersionUID = -6762037404466323951L;
    private final HashMap<Long, BigDecimal> privateValues;
    private transient CATSWorld world;
    private transient ImmutableMap<Long, BigDecimal> privateValueMap;

    CATSBidder(CATSBidderSetup setup, CATSWorld world, long currentId, long population, RNGSupplier rngSupplier) {
        super(setup, population, currentId, world.getId());
        this.world = world;
        this.privateValues = setup.drawPrivateValues(rngSupplier, this);
        this.store();
    }

    @Override
    public BigDecimal calculateValue(Bundle bundle) {
        double value = 0.0;
        for (Good good : bundle.getSingleQuantityGoods()) {
            CATSLicense license = (CATSLicense)good;
            if (!this.privateValues.containsKey(license.getLongId())) continue;
            value += license.getCommonValue();
            value += this.privateValues.get(license.getLongId()).doubleValue();
            if (!this.getWorld().getUseQuadraticPricingOption()) continue;
            value += Math.pow(license.getCommonValue(), 2.0);
        }
        if (!this.getWorld().getUseQuadraticPricingOption()) {
            value += Math.pow(bundle.getSingleQuantityGoods().size(), 1.0 + this.world.getAdditivity());
        }
        return BigDecimal.valueOf(value);
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> clazz, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
        if (clazz.isAssignableFrom(CatsXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new CatsXOR((Collection<CATSLicense>)this.world.getLicenses(), rngSupplier, this)));
        }
        if (clazz.isAssignableFrom(SizeBasedUniqueRandomXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new SizeBasedUniqueRandomXOR((Collection<? extends License>)this.world.getLicenses(), rngSupplier, this)));
        }
        if (clazz.isAssignableFrom(IncreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new IncreasingSizeOrderedXOR((Collection<? extends License>)this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(DecreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new DecreasingSizeOrderedXOR((Collection<? extends License>)this.world.getLicenses(), this)));
        }
        throw new UnsupportedBiddingLanguageException();
    }

    @Override
    public CATSWorld getWorld() {
        return this.world;
    }

    public ImmutableMap<Long, BigDecimal> getPrivateValues() {
        if (this.privateValueMap == null) {
            this.privateValueMap = ImmutableMap.copyOf(this.privateValues);
        }
        return this.privateValueMap;
    }

    @Override
    public void refreshReference(World world) {
        Preconditions.checkArgument((world.getId() == this.getWorldId() ? 1 : 0) != 0);
        if (!(world instanceof CATSWorld)) {
            throw new IllegalArgumentException("World is not of correct type");
        }
        this.world = (CATSWorld)world;
    }

    @Override
    public SATSBidder drawSimilarBidder(RNGSupplier rngSupplier) {
        return new CATSBidder((CATSBidderSetup)this.getSetup(), this.getWorld(), this.getLongId(), this.getPopulation(), rngSupplier);
    }

    public LinkedHashSet<Bundle> getBestBundles(Prices prices, int maxNumberOfBundles, boolean allowNegative) {
        throw new NotImplementedException("Demand Query to be implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CATSBidder)) {
            return false;
        }
        CATSBidder other = (CATSBidder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImmutableMap<Long, BigDecimal> this$privateValues = this.getPrivateValues();
        ImmutableMap<Long, BigDecimal> other$privateValues = other.getPrivateValues();
        return !(this$privateValues == null ? other$privateValues != null : !this$privateValues.equals(other$privateValues));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CATSBidder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ImmutableMap<Long, BigDecimal> $privateValues = this.getPrivateValues();
        result = result * 59 + ($privateValues == null ? 43 : $privateValues.hashCode());
        return result;
    }
}

