/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.cats;

import com.google.common.base.Preconditions;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.cats.CATSWorld;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Vertex;

public class CATSLicense
extends License {
    private static final long serialVersionUID = 5732211251618769420L;
    private final Vertex vertex;
    private final double commonValue;
    private transient CATSWorld world;

    CATSLicense(Vertex vertex, double commonValue, CATSWorld world) {
        super(vertex.getID(), world.getId());
        this.commonValue = commonValue;
        this.vertex = vertex;
        this.world = world;
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    @Override
    public CATSWorld getWorld() {
        return this.world;
    }

    public double getCommonValue() {
        return this.commonValue;
    }

    public void refreshFieldBackReferences(CATSWorld world) {
        Preconditions.checkArgument((world.getId() == this.worldId ? 1 : 0) != 0);
        this.world = world;
    }
}

