/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.cats;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.cats.CATSBidder;
import org.spectrumauctions.sats.core.model.cats.CATSBidderSetup;
import org.spectrumauctions.sats.core.model.cats.CATSLicense;
import org.spectrumauctions.sats.core.model.cats.CATSWorldSetup;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Graph;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Mesh2D;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Vertex;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public final class CATSWorld
extends World {
    private static final long serialVersionUID = 1794771578755986936L;
    private static final String MODEL_NAME = "CATS Region Value Model";
    private final double additivity;
    private final double additionalLocation;
    private double budgetFactor;
    private double resaleFactor;
    private double jumpProbability;
    private double deviation;
    private final boolean useQuadraticPricingOption;
    private final Mesh2D grid;
    private final int size;
    private final List<CATSLicense> licenses;
    private transient ImmutableList<CATSLicense> licenseList;
    private int maxSubstitutableBids;

    public CATSWorld(CATSWorldSetup worldSetup, RNGSupplier rngSupplier) {
        super(MODEL_NAME);
        int numberOfColumns;
        int numberOfRows;
        if (worldSetup.hasDefinedNumberOfGoodsInterval()) {
            int numberOfGoods = worldSetup.drawNumberOfGoods(rngSupplier);
            numberOfRows = (int)Math.floor(Math.sqrt(numberOfGoods));
            numberOfColumns = (int)Math.floor(Math.sqrt(numberOfGoods));
        } else {
            numberOfRows = worldSetup.drawNumberOfRows(rngSupplier);
            numberOfColumns = worldSetup.drawNumberOfColumns(rngSupplier);
        }
        this.grid = worldSetup.buildProximityGraph(numberOfRows, numberOfColumns, rngSupplier);
        this.licenses = new ArrayList<CATSLicense>();
        for (Vertex vertex : this.grid.getVertices()) {
            this.licenses.add(new CATSLicense(vertex, worldSetup.drawCommonValue(rngSupplier), this));
        }
        this.size = this.grid.getVertices().size();
        this.additivity = worldSetup.getAdditivity();
        this.additionalLocation = worldSetup.getAdditionalLocation();
        this.budgetFactor = worldSetup.getBudgetFactor();
        this.resaleFactor = worldSetup.getResaleFactor();
        this.jumpProbability = worldSetup.getJumpProbability();
        this.deviation = worldSetup.getDeviation();
        this.maxSubstitutableBids = worldSetup.getMaxSubstitutableBids();
        this.useQuadraticPricingOption = worldSetup.useQuadraticPricingOption();
        this.store();
    }

    public List<CATSBidder> restorePopulation(long populationId) {
        return super.restorePopulation(CATSBidder.class, populationId);
    }

    public ImmutableList<CATSLicense> getLicenses() {
        if (this.licenseList == null) {
            this.licenseList = ImmutableList.copyOf(this.licenses);
        }
        return this.licenseList;
    }

    @Override
    public int getNumberOfGoods() {
        return this.getLicenses().size();
    }

    @Override
    public void refreshFieldBackReferences() {
        for (CATSLicense license : this.licenses) {
            license.refreshFieldBackReferences(this);
        }
    }

    public List<CATSBidder> createPopulation(List<CATSBidderSetup> setups, RNGSupplier populationRNG) {
        long population = this.openNewPopulation();
        long currentId = 0L;
        ArrayList<CATSBidder> bidders = new ArrayList<CATSBidder>();
        for (CATSBidderSetup setup : setups) {
            for (int i = 0; i < setup.getNumberOfBidders(); ++i) {
                bidders.add(new CATSBidder(setup, this, currentId++, population, populationRNG));
            }
        }
        return bidders;
    }

    public double getAdditivity() {
        return this.additivity;
    }

    public double getAdditionalLocation() {
        return this.additionalLocation;
    }

    public double getBudgetFactor() {
        return this.budgetFactor;
    }

    public double getResaleFactor() {
        return this.resaleFactor;
    }

    public int getSize() {
        return this.size;
    }

    public Graph getGrid() {
        return this.grid;
    }

    public boolean getUseQuadraticPricingOption() {
        return this.useQuadraticPricingOption;
    }

    public double getJumpProbability() {
        return this.jumpProbability;
    }

    public double getDeviation() {
        return this.deviation;
    }

    public int getMaxSubstitutableBids() {
        return this.maxSubstitutableBids;
    }
}

