/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.cats.graphalgorithms;

import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Vertex;

public class Edge {
    private Vertex _source;
    private Vertex _sink;
    private double _capacity;
    private double[] _flow;

    public Edge(Vertex source, Vertex sink, int numberOfFlows) {
        this.init(source, sink, 0.0, numberOfFlows);
    }

    public Edge(Vertex source, Vertex sink, double capacity, int numberOfFlows) {
        this.init(source, sink, capacity, numberOfFlows);
    }

    public void init(Vertex source, Vertex sink, double capacity, int numberOfFlows) {
        this._source = source;
        this._sink = sink;
        this._capacity = capacity;
        this._flow = new double[numberOfFlows];
    }

    public boolean equals(Object other) {
        Edge otherEdge = (Edge)other;
        return this._source == otherEdge.getSource() && this._sink == otherEdge.getSink();
    }

    public String toString() {
        Object res = "";
        res = (String)res + this._source.getID() + " -(c=" + this._capacity + ")-> " + this._sink.getID();
        for (int i = 0; i < this._flow.length; ++i) {
            res = (String)res + " f" + i + "=" + this._flow[i] + " ";
        }
        return res;
    }

    public String getName() {
        Object res = "";
        res = (String)res + this._source.getID() + "," + this._sink.getID();
        return res;
    }

    public String getInvName() {
        Object res = "";
        res = (String)res + this._sink.getID() + "," + this._source.getID();
        return res;
    }

    public double getCapacity() {
        return this._capacity;
    }

    public Vertex getSource() {
        return this._source;
    }

    public Vertex getSink() {
        return this._sink;
    }

    public void setFLow(int i, double f) {
        this._flow[i] = f;
    }

    public double getFlow(int i) {
        return this._flow[i];
    }

    public int getNumberOfFlows() {
        return this._flow.length;
    }
}

