/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.gsvm;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.gsvm.GSVMCircle;
import org.spectrumauctions.sats.core.model.gsvm.GSVMWorld;

public class GSVMLicense
extends License {
    private static final long serialVersionUID = 5732211251672586420L;
    private final int position;
    private transient GSVMWorld world;

    GSVMLicense(long id, int position, GSVMWorld world) {
        super(id, world.getId());
        this.position = position;
        this.world = world;
    }

    @Override
    public GSVMWorld getWorld() {
        return this.world;
    }

    public void refreshFieldBackReferences(GSVMCircle circle) {
        Preconditions.checkArgument((circle.getWorld().getId() == this.worldId ? 1 : 0) != 0);
        this.world = circle.getWorld();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GSVMLicense that = (GSVMLicense)o;
        return this.position == that.position && Objects.equals(this.world, that.world);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.position, this.world);
    }

    public int getPosition() {
        return this.position;
    }
}

