/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.gsvm;

import java.util.HashSet;
import java.util.List;
import org.spectrumauctions.sats.core.model.DefaultModel;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidder;
import org.spectrumauctions.sats.core.model.gsvm.GSVMNationalBidderSetup;
import org.spectrumauctions.sats.core.model.gsvm.GSVMRegionalBidderSetup;
import org.spectrumauctions.sats.core.model.gsvm.GSVMWorld;
import org.spectrumauctions.sats.core.model.gsvm.GSVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public class GlobalSynergyValueModel
extends DefaultModel<GSVMWorld, GSVMBidder> {
    private final GSVMWorldSetup.GSVMWorldSetupBuilder worldSetupBuilder = new GSVMWorldSetup.GSVMWorldSetupBuilder();
    private final GSVMNationalBidderSetup.Builder nationalBidderBuilder = new GSVMNationalBidderSetup.Builder();
    private final GSVMRegionalBidderSetup.Builder regionalBidderBuilder = new GSVMRegionalBidderSetup.Builder();

    @Override
    public GSVMWorld createWorld(RNGSupplier worldSeed) {
        return new GSVMWorld(this.worldSetupBuilder.build(), worldSeed);
    }

    @Override
    public List<GSVMBidder> createPopulation(GSVMWorld world, RNGSupplier populationRNG) {
        HashSet<GSVMRegionalBidderSetup> regionalSetups = new HashSet<GSVMRegionalBidderSetup>();
        regionalSetups.add(this.regionalBidderBuilder.build());
        HashSet<GSVMNationalBidderSetup> nationalSetups = new HashSet<GSVMNationalBidderSetup>();
        nationalSetups.add(this.nationalBidderBuilder.build());
        return world.createPopulation(regionalSetups, nationalSetups, populationRNG);
    }

    public void setNumberOfNationalBidders(int numberOfBidders) {
        this.nationalBidderBuilder.setNumberOfBidders(numberOfBidders);
    }

    public void setNumberOfRegionalBidders(int numberOfBidders) {
        this.regionalBidderBuilder.setNumberOfBidders(numberOfBidders);
    }

    public void setLegacyGSVM(boolean legacyGSVM) {
        this.worldSetupBuilder.setLegacyGSVM(legacyGSVM);
    }
}

