/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.lsvm;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.lsvm.LSVMBidder;
import org.spectrumauctions.sats.core.model.lsvm.LSVMBidderSetup;
import org.spectrumauctions.sats.core.model.lsvm.LSVMGrid;
import org.spectrumauctions.sats.core.model.lsvm.LSVMLicense;
import org.spectrumauctions.sats.core.model.lsvm.LSVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public final class LSVMWorld
extends World {
    private static final long serialVersionUID = 1737956689715986936L;
    private static final String MODEL_NAME = "Local Synergy Value Model";
    private final LSVMGrid grid;
    private final boolean isLegacyLSVM;

    public LSVMWorld(LSVMWorldSetup worldSetup, RNGSupplier rngSupplier) {
        super(MODEL_NAME);
        UniformDistributionRNG uniformDistributionRNG = rngSupplier.getUniformDistributionRNG();
        this.grid = new LSVMGrid(this, worldSetup, uniformDistributionRNG);
        this.isLegacyLSVM = worldSetup.isLegacyLSVM();
        this.store();
    }

    public LSVMGrid getGrid() {
        return this.grid;
    }

    public List<LSVMBidder> restorePopulation(long populationId) {
        return super.restorePopulation(LSVMBidder.class, populationId);
    }

    public ImmutableList<LSVMLicense> getLicenses() {
        return this.grid.getLicenses();
    }

    @Override
    public int getNumberOfGoods() {
        return this.grid.getLicenses().size();
    }

    @Override
    public void refreshFieldBackReferences() {
        this.grid.refreshFieldBackReferences(this);
    }

    public List<LSVMBidder> createPopulation(List<LSVMBidderSetup> setups, RNGSupplier populationRNG) {
        long population = this.openNewPopulation();
        long currentId = 0L;
        ArrayList<LSVMBidder> bidders = new ArrayList<LSVMBidder>();
        for (LSVMBidderSetup setup : setups) {
            for (int i = 0; i < setup.getNumberOfBidders(); ++i) {
                bidders.add(new LSVMBidder(setup, this, currentId++, population, populationRNG));
            }
        }
        return bidders;
    }

    public boolean isLegacyLSVM() {
        return this.isLegacyLSVM;
    }
}

