/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.lsvm;

import java.util.ArrayList;
import java.util.List;
import org.spectrumauctions.sats.core.model.DefaultModel;
import org.spectrumauctions.sats.core.model.lsvm.LSVMBidder;
import org.spectrumauctions.sats.core.model.lsvm.LSVMBidderSetup;
import org.spectrumauctions.sats.core.model.lsvm.LSVMWorld;
import org.spectrumauctions.sats.core.model.lsvm.LSVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public class LocalSynergyValueModel
extends DefaultModel<LSVMWorld, LSVMBidder> {
    private final LSVMWorldSetup.LSVMWorldSetupBuilder worldSetupBuilder = new LSVMWorldSetup.LSVMWorldSetupBuilder();
    private final LSVMBidderSetup.NationalBidderBuilder nationalBidderBuilder = new LSVMBidderSetup.NationalBidderBuilder();
    private final LSVMBidderSetup.RegionalBidderBuilder regionalBidderBuilder = new LSVMBidderSetup.RegionalBidderBuilder();

    @Override
    public LSVMWorld createWorld(RNGSupplier worldSeed) {
        return new LSVMWorld(this.worldSetupBuilder.build(), worldSeed);
    }

    @Override
    public List<LSVMBidder> createPopulation(LSVMWorld world, RNGSupplier populationRNG) {
        ArrayList<LSVMBidderSetup> setups = new ArrayList<LSVMBidderSetup>();
        setups.add(this.nationalBidderBuilder.build());
        setups.add(this.regionalBidderBuilder.build());
        return world.createPopulation(setups, populationRNG);
    }

    public void setNumberOfNationalBidders(int numberOfBidders) {
        this.nationalBidderBuilder.setNumberOfBidders(numberOfBidders);
    }

    public void setNumberOfRegionalBidders(int numberOfBidders) {
        this.regionalBidderBuilder.setNumberOfBidders(numberOfBidders);
    }

    public void setLegacyLSVM(boolean legacyLSVM) {
        this.worldSetupBuilder.setLegacyLSVM(legacyLSVM);
    }
}

