/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.base.Preconditions;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimit;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimitConstraint;
import org.marketdesignresearch.mechlib.core.bundlesampling.UniformRandomBundleSampling;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;

public class MRVMAllocationLimit
extends AllocationLimit {
    protected static final String LOW_PAIRED_NAME = "LOW_PAIRED";
    protected static final String HIGH_PAIRED_NAME = "HIGH_PAIRED";
    protected static final String UNPAIRED_NAME = "UNPAIRED";
    private Map<MRVMRegionsMap.Region, List<License>> goodsPerRegion = new LinkedHashMap<MRVMRegionsMap.Region, List<License>>();

    public MRVMAllocationLimit(MRVMBidder bidder) {
        super(bidder.getWorld().getLicenses());
        ArrayList<MRVMBand> pairedBands = new ArrayList<MRVMBand>();
        pairedBands.add(bidder.getWorld().getBands().stream().filter(b -> b.getName().equals(LOW_PAIRED_NAME)).findAny().orElseThrow());
        pairedBands.add(bidder.getWorld().getBands().stream().filter(b -> b.getName().equals(HIGH_PAIRED_NAME)).findAny().orElseThrow());
        for (MRVMRegionsMap.Region region : bidder.getWorld().getRegionsMap().getRegions()) {
            AllocationLimitConstraint constraint = new AllocationLimitConstraint(CompareType.LEQ, 2.0);
            bidder.getWorld().getLicenses().stream().filter(l -> l.getRegion().equals(region)).filter(l -> pairedBands.contains(l.getBand())).forEach(l -> constraint.addTerm(1.0, (Good)l));
            this.addAllocationLimitConstraint(constraint);
            this.goodsPerRegion.put(region, bidder.getWorld().getLicenses().stream().filter(l -> l.getRegion().equals(region)).collect(Collectors.toList()));
        }
    }

    public int calculateAllocationBundleSpace(List<? extends Good> startingSpace) {
        return Integer.MAX_VALUE;
    }

    public Bundle getUniformRandomBundle(Random random, List<? extends Good> goods) {
        Preconditions.checkArgument((boolean)this.validateDomainCompatiblity(goods));
        UniformRandomBundleSampling randomSampling = new UniformRandomBundleSampling(random);
        Bundle bundle = Bundle.EMPTY;
        for (Map.Entry<MRVMRegionsMap.Region, List<License>> entry : this.goodsPerRegion.entrySet()) {
            Bundle regionBundle;
            ArrayList<? extends Good> regionalGoods = new ArrayList<Good>(goods);
            regionalGoods.retainAll((Collection)entry.getValue());
            while (!this.validate(regionBundle = randomSampling.getSingleBundle(regionalGoods))) {
            }
            bundle = bundle.merge(regionBundle);
        }
        return bundle;
    }
}

