/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.base.Preconditions;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimit;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimitConstraint;
import org.marketdesignresearch.mechlib.core.bundlesampling.UniformRandomBundleSampling;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMGenericDefinition;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;

public class MRVMGenericAllocationLimit
extends AllocationLimit {
    protected static final String LOW_PAIRED_NAME = "LOW_PAIRED";
    protected static final String HIGH_PAIRED_NAME = "HIGH_PAIRED";
    protected static final String UNPAIRED_NAME = "UNPAIRED";
    private Map<MRVMRegionsMap.Region, List<MRVMGenericDefinition>> goodsPerRegion = new LinkedHashMap<MRVMRegionsMap.Region, List<MRVMGenericDefinition>>();

    public MRVMGenericAllocationLimit(MRVMBidder bidder) {
        super(bidder.getWorld().getAllGenericDefinitions());
        for (MRVMRegionsMap.Region region : bidder.getWorld().getRegionsMap().getRegions()) {
            MRVMGenericDefinition varLp = bidder.getWorld().getAllGenericDefinitions().stream().filter(g -> g.getBand().getName().equals(LOW_PAIRED_NAME) && g.getRegion().equals(region)).findFirst().get();
            MRVMGenericDefinition varHp = bidder.getWorld().getAllGenericDefinitions().stream().filter(g -> g.getBand().getName().equals(HIGH_PAIRED_NAME) && g.getRegion().equals(region)).findFirst().get();
            AllocationLimitConstraint constraint = new AllocationLimitConstraint(CompareType.LEQ, 2.0);
            constraint.addTerm(1.0, (Good)varLp);
            constraint.addTerm(1.0, (Good)varHp);
            this.addAllocationLimitConstraint(constraint);
            this.goodsPerRegion.put(region, bidder.getWorld().getAllGenericDefinitions().stream().filter(g -> g.getRegion().equals(region)).collect(Collectors.toList()));
        }
    }

    public int calculateAllocationBundleSpace(List<? extends Good> startingSpace) {
        return Integer.MAX_VALUE;
    }

    public Bundle getUniformRandomBundle(Random random, List<? extends Good> goods) {
        Preconditions.checkArgument((boolean)this.validateDomainCompatiblity(goods));
        UniformRandomBundleSampling randomSampling = new UniformRandomBundleSampling(random);
        Bundle bundle = Bundle.EMPTY;
        for (Map.Entry<MRVMRegionsMap.Region, List<MRVMGenericDefinition>> entry : this.goodsPerRegion.entrySet()) {
            Bundle regionBundle;
            ArrayList<? extends Good> regionalGoods = new ArrayList<Good>(goods);
            regionalGoods.retainAll((Collection)entry.getValue());
            while (!this.validate(regionBundle = randomSampling.getSingleBundle(regionalGoods))) {
            }
            bundle = bundle.merge(regionBundle);
        }
        return bundle;
    }
}

