/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimit;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMGenericDefinition;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLocalBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;
import org.spectrumauctions.sats.opt.model.mrvm.MRVM_MIP;

public final class MRVMLocalBidder
extends MRVMBidder {
    private static final long serialVersionUID = -7654713373213024311L;
    private transient Map<MRVMRegionsMap.Region, BigDecimal> gammaFactorCache = null;
    final Set<Integer> regionsOfInterest;
    private final boolean allowAssigningLicensesWithZeroBasevalueInDemandQuery;

    MRVMLocalBidder(long id, long populationId, MRVMWorld world, MRVMLocalBidderSetup setup, UniformDistributionRNG rng, AllocationLimit limit) {
        super(id, populationId, world, setup, rng, limit);
        Set<MRVMRegionsMap.Region> regionsOfInterest = setup.drawRegionsOfInterest(world, rng);
        HashSet<Integer> regionsOfInterestIds = new HashSet<Integer>();
        for (MRVMRegionsMap.Region region : regionsOfInterest) {
            if (!this.getWorld().getRegionsMap().getRegions().contains(region)) {
                throw new IllegalArgumentException("Region of Interest of this bidder is not part of the same world as this bidder");
            }
            regionsOfInterestIds.add(region.getId());
        }
        this.regionsOfInterest = Collections.unmodifiableSet(regionsOfInterestIds);
        this.allowAssigningLicensesWithZeroBasevalueInDemandQuery = setup.isAllowAssigningLicensesWithZeroBasevalueInDemandQuery();
        this.store();
    }

    private static Map<MRVMRegionsMap.Region, BigDecimal> mapGammaFactors(MRVMWorld world, Set<Integer> regionsOfInterest) {
        HashMap<MRVMRegionsMap.Region, BigDecimal> result = new HashMap<MRVMRegionsMap.Region, BigDecimal>();
        for (MRVMRegionsMap.Region region : world.getRegionsMap().getRegions()) {
            BigDecimal gammaFactor = regionsOfInterest.contains(region.getId()) ? BigDecimal.ONE : BigDecimal.ZERO;
            result.put(region, gammaFactor);
        }
        return result;
    }

    @Override
    public BigDecimal gammaFactor(MRVMRegionsMap.Region r, Set<MRVMLicense> bundle) {
        return this.gammaFactors(bundle).get(r);
    }

    @Override
    public Map<MRVMRegionsMap.Region, BigDecimal> gammaFactors(Set<MRVMLicense> bundle) {
        if (this.gammaFactorCache == null) {
            this.gammaFactorCache = MRVMLocalBidder.mapGammaFactors(this.getWorld(), this.regionsOfInterest);
        }
        return Collections.unmodifiableMap(this.gammaFactorCache);
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> type, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
        return super.getValueFunction(type, rngSupplier);
    }

    @Override
    public MRVMLocalBidder drawSimilarBidder(RNGSupplier rngSupplier) {
        return new MRVMLocalBidder(this.getLongId(), this.getPopulation(), this.getWorld(), (MRVMLocalBidderSetup)this.getSetup(), rngSupplier.getUniformDistributionRNG(), this.getAllocationLimit());
    }

    @Override
    protected void bidderTypeSpecificDemandQueryMIPAdjustments(MRVM_MIP mip) {
        if (!this.allowAssigningLicensesWithZeroBasevalueInDemandQuery) {
            for (MRVMGenericDefinition bandInRegion : this.getWorld().getAllGenericDefinitions()) {
                if (this.regionsOfInterest.contains(bandInRegion.getRegion().getId())) continue;
                Variable xVariable = mip.getWorldPartialMip().getXVariable(this, bandInRegion.getRegion(), bandInRegion.getBand());
                xVariable.setUpperBound(0.0);
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.regionsOfInterest == null ? 0 : this.regionsOfInterest.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MRVMLocalBidder other = (MRVMLocalBidder)obj;
        return !(this.regionsOfInterest == null ? other.regionsOfInterest != null : !this.regionsOfInterest.containsAll(other.regionsOfInterest) && this.regionsOfInterest.size() == other.regionsOfInterest.size());
    }
}

