/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.util.List;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimitConstraint;
import org.spectrumauctions.sats.core.model.mrvm.MRVMGenericAllocationLimit;
import org.spectrumauctions.sats.core.model.mrvm.MRVMGenericDefinition;
import org.spectrumauctions.sats.core.model.mrvm.MRVMNationalBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;

public class MRVMNationalBidderGenericAllocationLimit
extends MRVMGenericAllocationLimit {
    public MRVMNationalBidderGenericAllocationLimit(MRVMNationalBidder bidder) {
        super(bidder);
        for (MRVMRegionsMap.Region region : bidder.getWorld().getRegionsMap().getRegions()) {
            MRVMGenericDefinition varLp = bidder.getWorld().getAllGenericDefinitions().stream().filter(g -> g.getBand().getName().equals("LOW_PAIRED") && g.getRegion().equals(region)).findFirst().get();
            MRVMGenericDefinition varHp = bidder.getWorld().getAllGenericDefinitions().stream().filter(g -> g.getBand().getName().equals("HIGH_PAIRED") && g.getRegion().equals(region)).findFirst().get();
            String varName = "AgggregationLimitXhat_i=" + bidder.getId() + "_r=" + region.getId() + "b=LP";
            Variable hatVarLP = new Variable(varName, VarType.BOOLEAN, 0.0, 1.0);
            AllocationLimitConstraint upperLimitConstraint = new AllocationLimitConstraint(CompareType.LEQ, 0.0);
            upperLimitConstraint.addTerm(1.0, hatVarLP);
            upperLimitConstraint.addTerm(-1.0, (Good)varLp);
            this.addAllocationLimitConstraint(upperLimitConstraint);
            AllocationLimitConstraint lowerLimitConstraint = new AllocationLimitConstraint(CompareType.GEQ, 0.0);
            lowerLimitConstraint.addTerm(1.0, hatVarLP);
            lowerLimitConstraint.addTerm(-1.0 / (double)varLp.getQuantity(), (Good)varLp);
            this.addAllocationLimitConstraint(lowerLimitConstraint);
            varName = "AgggregationLimitXhat_i=" + bidder.getId() + "_r=" + region.getId() + "b=HP";
            Variable hatVarHP = new Variable(varName, VarType.BOOLEAN, 0.0, 1.0);
            upperLimitConstraint = new AllocationLimitConstraint(CompareType.LEQ, 0.0);
            upperLimitConstraint.addTerm(1.0, hatVarHP);
            upperLimitConstraint.addTerm(-1.0, (Good)varHp);
            this.addAllocationLimitConstraint(upperLimitConstraint);
            lowerLimitConstraint = new AllocationLimitConstraint(CompareType.GEQ, 0.0);
            lowerLimitConstraint.addTerm(1.0, hatVarHP);
            lowerLimitConstraint.addTerm(-1.0 / (double)varHp.getQuantity(), (Good)varHp);
            this.addAllocationLimitConstraint(lowerLimitConstraint);
            AllocationLimitConstraint onlyOne = new AllocationLimitConstraint(CompareType.LEQ, 1.0);
            onlyOne.addTerm(1.0, hatVarHP);
            onlyOne.addTerm(1.0, hatVarLP);
            this.addAllocationLimitConstraint(onlyOne);
            AllocationLimitConstraint maxOneInHP = new AllocationLimitConstraint(CompareType.LEQ, 1.0);
            maxOneInHP.addTerm(1.0, (Good)varHp);
            this.addAllocationLimitConstraint(maxOneInHP);
        }
    }

    @Override
    public int calculateAllocationBundleSpace(List<? extends Good> startingSpace) {
        return Integer.MAX_VALUE;
    }
}

