/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public class MRVMNationalBidderSetup
extends MRVMBidderSetup {
    private static final double f = 2.0;
    private final DoubleInterval bInterval;
    private double kMax = 2.0;

    protected MRVMNationalBidderSetup(Builder builder) {
        super(builder);
        this.bInterval = builder.bInterval;
    }

    public Map<Integer, BigDecimal> drawGamma(MRVMWorld world, UniformDistributionRNG rng) {
        if (this.kMax > (double)world.getRegionsMap().getNumberOfRegions()) {
            this.kMax = world.getRegionsMap().getNumberOfRegions();
        }
        double b = rng.nextDouble(this.bInterval);
        HashMap<Integer, BigDecimal> gammas = new HashMap<Integer, BigDecimal>();
        int i = 1;
        while ((double)i <= this.kMax) {
            double gamma = 1.0 - Math.pow((double)i * b, 2.0);
            Preconditions.checkState((gamma >= 0.0 && gamma <= 1.0 ? 1 : 0) != 0, (Object)"Invalid Gamma, some of the calculation parameters have unallowed values");
            BigDecimal roundedGamma = BigDecimal.valueOf(gamma).setScale(5, 5);
            gammas.put(i, roundedGamma);
            ++i;
        }
        return gammas;
    }

    public static class Builder
    extends MRVMBidderSetup.Builder {
        private DoubleInterval bInterval = new DoubleInterval(0.1, 0.3);

        public Builder() {
            super("Multi Region Model National Bidder", 3, new DoubleInterval(700.0, 1200.0), new DoubleInterval(0.08, 0.22));
        }

        public void setbInterval(DoubleInterval bInterval) {
            Preconditions.checkArgument((bInterval.getMinValue() >= 0.0 && bInterval.getMaxValue() <= 0.5 ? 1 : 0) != 0, (Object)"bInterval has to be within [0, 0.5]!");
            this.bInterval = bInterval;
        }

        @Override
        public MRVMNationalBidderSetup build() {
            return new MRVMNationalBidderSetup(this);
        }
    }
}

