/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jgrapht.Graph;
import org.jgrapht.generate.GnmRandomGraphGenerator;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultUndirectedGraph;
import org.jgrapht.util.SupplierUtil;
import org.spectrumauctions.sats.core.model.mrvm.CanadianMap;
import org.spectrumauctions.sats.core.util.math.ContinuousPiecewiseLinearFunction;
import org.spectrumauctions.sats.core.util.math.Function;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.GaussianDistributionRNG;
import org.spectrumauctions.sats.core.util.random.IntegerInterval;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public final class MRVMWorldSetup {
    private final ImmutableMap<String, BandSetup> bandSetups;
    private final IntegerInterval numberOfRegionsInterval;
    private final IntegerInterval averageAdjacenciesPerRegionInterval;
    private final double populationPerRegionMean;
    private final double populationStandardDeviation;
    private final boolean usePredefinedGraph;
    private final Graph<RegionSetup, DefaultEdge> predefinedGraph;
    private int randomRegionCount = 0;

    private MRVMWorldSetup(MRVMWorldSetupBuilder builder) {
        this.bandSetups = ImmutableMap.copyOf(builder.bandSetups);
        this.numberOfRegionsInterval = builder.numberOfRegionsInterval;
        this.averageAdjacenciesPerRegionInterval = builder.averageAdjacenciesPerRegionInterval;
        this.populationPerRegionMean = builder.populationPerRegionMean;
        this.populationStandardDeviation = builder.populationStandardDeviation;
        this.usePredefinedGraph = builder.usePredefinedGraph;
        this.predefinedGraph = builder.predefinedGraph;
    }

    public Set<BandSetup> getBandSetups() {
        return ImmutableSet.copyOf((Collection)this.bandSetups.values());
    }

    public Graph<RegionSetup, DefaultEdge> drawGraphStructure(UniformDistributionRNG rng) {
        if (this.usePredefinedGraph) {
            return this.predefinedGraph;
        }
        return this.nonPlanarRandomGraphStructure(this.populationPerRegionMean, this.populationStandardDeviation, rng, this.numberOfRegionsInterval, this.averageAdjacenciesPerRegionInterval);
    }

    public Graph<RegionSetup, DefaultEdge> nonPlanarRandomGraphStructure(double populationPerRegionMean, double populationStandardDeviation, UniformDistributionRNG rng, IntegerInterval numberOfRegionsInterval, IntegerInterval averageAdjacenciesPerRegionInterval) {
        int numberOfRegions = rng.nextInt(numberOfRegionsInterval);
        int numberOfAdjacencies = rng.nextInt(averageAdjacenciesPerRegionInterval) * numberOfRegions;
        GnmRandomGraphGenerator randomGraphGenerator = new GnmRandomGraphGenerator(numberOfRegions, numberOfAdjacencies, rng.nextLong());
        Supplier<RegionSetup> vertexFactory = () -> new RegionSetup(populationPerRegionMean, populationStandardDeviation, this.randomRegionCount++ + ": randomly created");
        DefaultUndirectedGraph targetGraph = new DefaultUndirectedGraph(vertexFactory, SupplierUtil.createDefaultEdgeSupplier(), false);
        randomGraphGenerator.generateGraph((Graph)targetGraph);
        return targetGraph;
    }

    public static class MRVMWorldSetupBuilder {
        public static final String LOW_PAIRED_NAME = "LOW_PAIRED";
        public static final String HIGH_PAIRED_NAME = "HIGH_PAIRED";
        public static final String UNPAIRED_NAME = "UNPAIRED";
        public Graph<RegionSetup, DefaultEdge> predefinedGraph;
        public boolean usePredefinedGraph = true;
        private double populationStandardDeviation;
        private double populationPerRegionMean;
        private IntegerInterval averageAdjacenciesPerRegionInterval;
        private IntegerInterval numberOfRegionsInterval;
        private final Map<String, BandSetup> bandSetups = new HashMap<String, BandSetup>();

        public MRVMWorldSetupBuilder() {
            this.predefinedGraph = CanadianMap.getInstance().createCanadianMapGraph();
            this.addDefaultBands();
        }

        private void addDefaultBands() {
            HashMap<BigDecimal, BigDecimal> cornerPoints = new HashMap<BigDecimal, BigDecimal>();
            cornerPoints.put(BigDecimal.ZERO, BigDecimal.ONE);
            cornerPoints.put(BigDecimal.valueOf(2L), BigDecimal.valueOf(1.2));
            cornerPoints.put(BigDecimal.valueOf(4.0), BigDecimal.valueOf(1L));
            ContinuousPiecewiseLinearFunction synergyFunction = new ContinuousPiecewiseLinearFunction(cornerPoints);
            this.putBandSetup(new BandSetup(LOW_PAIRED_NAME, new IntegerInterval(2), new DoubleInterval(3.0, 4.0), synergyFunction));
            this.putBandSetup(new BandSetup(HIGH_PAIRED_NAME, new IntegerInterval(3), new DoubleInterval(1.5, 2.5), synergyFunction));
            this.putBandSetup(new BandSetup(UNPAIRED_NAME, new IntegerInterval(2), new DoubleInterval(0.5, 1.0), synergyFunction));
        }

        public void createGraphRandomly(IntegerInterval numberOfRegions, IntegerInterval averageOfAdjacenciesPerRegion, double populationPerRegionMean, double populationPerRegionStandardDeviation) {
            this.usePredefinedGraph = false;
            this.setNumberOfRegionsInterval(numberOfRegions);
            this.setAverageAdjacenciesPerRegionInterval(averageOfAdjacenciesPerRegion);
            this.setPopulationPerRegionMean(populationPerRegionMean);
            this.setPopulationStandardDeviation(populationPerRegionStandardDeviation);
        }

        private void setNumberOfRegionsInterval(IntegerInterval numberOfRegions) {
            this.numberOfRegionsInterval = numberOfRegions;
        }

        public void createPredefinedGraph(Graph<RegionSetup, DefaultEdge> predefinedGraph) {
            this.predefinedGraph = predefinedGraph;
            this.usePredefinedGraph = true;
        }

        private void setPopulationStandardDeviation(double populationStandardDeviation) {
            this.populationStandardDeviation = populationStandardDeviation;
        }

        private void setPopulationPerRegionMean(double populationPerRegionMean) {
            this.populationPerRegionMean = populationPerRegionMean;
        }

        private void setAverageAdjacenciesPerRegionInterval(IntegerInterval averageAdjacenciesPerRegionInterval) {
            this.averageAdjacenciesPerRegionInterval = averageAdjacenciesPerRegionInterval;
        }

        public void changeNumberOfLots(String bandName, IntegerInterval numberOfLots) {
            BandSetup setup = this.bandSetups.get(bandName);
            if (setup == null) {
                throw new IllegalArgumentException("Band Name Unknown");
            }
            BandSetup newSetup = new BandSetup(setup.name, setup.numberOfLotsInterval, setup.baseCapacity, setup.synergies);
            this.bandSetups.put(bandName, newSetup);
        }

        public void putBandSetup(BandSetup bandStructure) {
            this.bandSetups.put(bandStructure.getName(), bandStructure);
        }

        public BandSetup removeBandSetup(String name) {
            return this.bandSetups.remove(name);
        }

        public Map<String, BandSetup> bandSetups() {
            return Collections.unmodifiableMap(this.bandSetups);
        }

        public MRVMWorldSetup build() {
            return new MRVMWorldSetup(this);
        }
    }

    public static final class BandSetup {
        private final String name;
        private final IntegerInterval numberOfLotsInterval;
        private final DoubleInterval baseCapacity;
        private final ImmutableMap<Integer, BigDecimal> synergies;

        public BandSetup(String name, IntegerInterval numberOfLotsInterval, DoubleInterval baseCapacity, Function synergyfunction) {
            this.name = name;
            this.numberOfLotsInterval = numberOfLotsInterval;
            this.baseCapacity = baseCapacity;
            this.synergies = BandSetup.calculateSynergies(numberOfLotsInterval.getMaxValue(), synergyfunction);
        }

        public BandSetup(String name, IntegerInterval numberOfLotsInterval, DoubleInterval baseCapacity, ImmutableMap<Integer, BigDecimal> synergies) {
            this.name = name;
            this.numberOfLotsInterval = numberOfLotsInterval;
            this.baseCapacity = baseCapacity;
            this.synergies = synergies;
        }

        private static ImmutableMap<Integer, BigDecimal> calculateSynergies(int maxNumberOfLots, Function synergyfunction) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 1; i <= maxNumberOfLots; ++i) {
                builder.put((Object)i, (Object)synergyfunction.getY(new BigDecimal(i)));
            }
            return builder.build();
        }

        public String getName() {
            return this.name;
        }

        public int drawNumberOfLots(UniformDistributionRNG rng) {
            return rng.nextInt(this.numberOfLotsInterval);
        }

        public BigDecimal drawBaseCapacity(UniformDistributionRNG rng) {
            return rng.nextBigDecimal(this.baseCapacity);
        }

        public Map<Integer, BigDecimal> getSynergies() {
            return this.synergies;
        }
    }

    public static final class RegionSetup {
        private final double populationMean;
        private final double populationStandardDeviation;
        private final String notice;

        public RegionSetup(double populationMean, double populationStandardDeviation, String notice) {
            this.populationMean = populationMean;
            this.populationStandardDeviation = populationStandardDeviation;
            this.notice = notice;
        }

        public String getNotice() {
            return this.notice;
        }

        public int drawPopulation(GaussianDistributionRNG rng) {
            int population = (int)rng.nextGaussian(this.populationMean, this.populationStandardDeviation);
            if (population > 0) {
                return population;
            }
            return this.drawPopulation(rng);
        }
    }
}

