/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.base.Preconditions;
import java.util.List;
import org.spectrumauctions.sats.core.model.DefaultModel;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLocalBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMNationalBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionalBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public class MultiRegionModel
extends DefaultModel<MRVMWorld, MRVMBidder> {
    private MRVMWorldSetup.MRVMWorldSetupBuilder worldBuilder = new MRVMWorldSetup.MRVMWorldSetupBuilder();
    private MRVMLocalBidderSetup.Builder localBidderBuilder = new MRVMLocalBidderSetup.Builder();
    private MRVMRegionalBidderSetup.Builder regionalBidderBuilder = new MRVMRegionalBidderSetup.Builder();
    private MRVMNationalBidderSetup.Builder nationalBidderBuilder = new MRVMNationalBidderSetup.Builder();

    @Override
    public MRVMWorld createWorld(RNGSupplier worldSeed) {
        return new MRVMWorld(this.worldBuilder.build(), worldSeed);
    }

    @Override
    public List<MRVMBidder> createPopulation(MRVMWorld world, RNGSupplier populationRNG) {
        return world.createPopulation(this.localBidderBuilder.build(), this.regionalBidderBuilder.build(), this.nationalBidderBuilder.build(), populationRNG);
    }

    public void setNumberOfLocalBidders(int number) {
        Preconditions.checkArgument((number >= 0 ? 1 : 0) != 0);
        this.localBidderBuilder.setNumberOfBidders(number);
    }

    public void setNumberOfRegionalBidders(int number) {
        Preconditions.checkArgument((number >= 0 ? 1 : 0) != 0);
        this.regionalBidderBuilder.setNumberOfBidders(number);
    }

    public void setNumberOfNationalBidders(int number) {
        Preconditions.checkArgument((number >= 0 ? 1 : 0) != 0);
        this.nationalBidderBuilder.setNumberOfBidders(number);
    }
}

