/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import org.spectrumauctions.sats.core.bidlang.generic.SimpleRandomOrder.XORQRandomOrderSimple;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidder;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

class RandomOrderXORQFactory
implements Serializable {
    private static final long serialVersionUID = -337996389686369882L;

    RandomOrderXORQFactory() {
    }

    public static XORQRandomOrderSimple getXORQRandomOrderSimpleLang(SRVMBidder bidder, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
        ImmutableList<SRVMBand> bands = bidder.getWorld().getBands();
        return new SimpleRandomOrder((List<SRVMBand>)bands, bidder, rngSupplier);
    }

    public static XORQRandomOrderSimple getXORQRandomOrderSimpleLang(SRVMBidder bidder) throws UnsupportedBiddingLanguageException {
        ImmutableList<SRVMBand> bands = bidder.getWorld().getBands();
        return new SimpleRandomOrder((List<SRVMBand>)bands, bidder, new JavaUtilRNGSupplier());
    }

    private static final class SimpleRandomOrder
    extends XORQRandomOrderSimple {
        private final SRVMBidder bidder;

        SimpleRandomOrder(List<SRVMBand> allPossibleGenericDefinitions, SRVMBidder bidder, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
            super(allPossibleGenericDefinitions, rngSupplier);
            this.bidder = bidder;
        }

        @Override
        public SATSBidder getBidder() {
            return this.bidder;
        }
    }
}

