/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.model.srvm.SRVMLicense;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorld;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public final class SRVMBand
extends GenericGood {
    private static final long serialVersionUID = 8297467604786037769L;
    private final List<SRVMLicense> licenses;
    private transient SRVMWorld world;

    static List<SRVMBand> createBands(SRVMWorld world, SRVMWorldSetup setup, RNGSupplier rngSupplier) {
        ArrayList<SRVMBand> bands = new ArrayList<SRVMBand>();
        int startId = 0;
        for (Map.Entry<String, Integer> bandDefinition : setup.defineBands(rngSupplier).entrySet()) {
            bands.add(new SRVMBand(bandDefinition.getKey(), world, bandDefinition.getValue(), startId));
            startId += bandDefinition.getValue().intValue();
        }
        Preconditions.checkArgument((bands.size() != 0 ? 1 : 0) != 0, (Object)"WorldSetup has to define at least one band");
        return bands;
    }

    private SRVMBand(String name, SRVMWorld world, int numberOfLicenses, int startId) {
        super(name, world.getId());
        this.world = world;
        ArrayList<SRVMLicense> builder = new ArrayList<SRVMLicense>();
        for (int i = 0; i < numberOfLicenses; ++i) {
            builder.add(new SRVMLicense((long)startId++, this));
        }
        this.licenses = ImmutableList.copyOf(builder);
    }

    @Override
    public SRVMWorld getWorld() {
        return this.world;
    }

    public ImmutableList<SRVMLicense> getLicenses() {
        return ImmutableList.copyOf(this.licenses);
    }

    void refreshFieldBackReferences(SRVMWorld world) {
        Preconditions.checkArgument((world.getId() == this.worldId ? 1 : 0) != 0);
        this.world = world;
        for (SRVMLicense license : this.licenses) {
            license.refreshFieldBackReferences(this);
        }
    }

    @Override
    public int getQuantity() {
        return this.licenses.size();
    }

    public boolean isPartOf(SRVMLicense license) {
        return license != null && license.getBand().equals(this);
    }

    public List<SRVMLicense> containedGoods() {
        return Collections.unmodifiableList(this.licenses);
    }

    @Override
    public JsonElement shortJson() {
        JsonObject json = new JsonObject();
        json.addProperty("band", this.getName());
        return json;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SRVMBand)) {
            return false;
        }
        SRVMBand other = (SRVMBand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImmutableList<SRVMLicense> this$licenses = this.getLicenses();
        ImmutableList<SRVMLicense> other$licenses = other.getLicenses();
        return !(this$licenses == null ? other$licenses != null : !this$licenses.equals(other$licenses));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SRVMBand;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ImmutableList<SRVMLicense> $licenses = this.getLicenses();
        result = result * 59 + ($licenses == null ? 43 : $licenses.hashCode());
        return result;
    }
}

