/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.BundleEntry;
import org.marketdesignresearch.mechlib.core.price.Prices;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeIncreasing;
import org.spectrumauctions.sats.core.bidlang.generic.SimpleRandomOrder.XORQRandomOrderSimple;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetIncreasing;
import org.spectrumauctions.sats.core.bidlang.xor.DecreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.IncreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.SizeBasedUniqueRandomXOR;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.WrongConfigException;
import org.spectrumauctions.sats.core.model.srvm.RandomOrderXORQFactory;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidderSetup;
import org.spectrumauctions.sats.core.model.srvm.SRVMLicense;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorld;
import org.spectrumauctions.sats.core.model.srvm.SizeOrderedGenericFactory;
import org.spectrumauctions.sats.core.model.srvm.SizeOrderedGenericPowersetFactory;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public final class SRVMBidder
extends SATSBidder {
    private static final int CALCSCALE = 5;
    private static final long serialVersionUID = -4577743658098455267L;
    private transient SRVMWorld world;
    private final BigDecimal bidderStrength;
    private final HashMap<String, Integer> synergyThreshold;
    private final HashMap<String, BigDecimal> baseValues;
    private final HashMap<String, BigDecimal> intrabandSynergyFactors;
    private final BigDecimal interbandSynergyValue;

    SRVMBidder(SRVMBidderSetup setup, SRVMWorld world, long currentId, long population, RNGSupplier rngSupplier) {
        super(setup, population, currentId, world.getId());
        this.world = world;
        HashMap<SRVMBand, Integer> synergyThreshold = setup.drawSynergyThresholds(world, rngSupplier);
        this.synergyThreshold = this.bandNameMap(synergyThreshold);
        this.bidderStrength = setup.drawBidderStrength(world, rngSupplier);
        HashMap<SRVMBand, BigDecimal> baseValues = setup.drawBaseValues(world, this.bidderStrength, rngSupplier);
        this.baseValues = this.bandNameMap(baseValues);
        HashMap<SRVMBand, BigDecimal> intrabandSynergyFactors = setup.drawIntraBandSynergyFactors(world, rngSupplier);
        this.intrabandSynergyFactors = this.bandNameMap(intrabandSynergyFactors);
        this.interbandSynergyValue = setup.drawInterBandSynergyFactor(world, rngSupplier);
        this.store();
    }

    private <T> HashMap<String, T> bandNameMap(Map<SRVMBand, T> inputMap) {
        Preconditions.checkArgument((this.world.getBands().containsAll(inputMap.keySet()) && this.world.getBands().size() == inputMap.size() ? 1 : 0) != 0, (Object)"Map is not complete for this world");
        HashMap<String, T> result = new HashMap<String, T>();
        for (Map.Entry<SRVMBand, T> inputEntry : inputMap.entrySet()) {
            result.put(inputEntry.getKey().getName(), inputEntry.getValue());
        }
        return result;
    }

    @Override
    public SRVMWorld getWorld() {
        return this.world;
    }

    public BigDecimal getBidderStrength() {
        return this.bidderStrength;
    }

    public Map<String, Integer> getSynergyThreshold() {
        return Collections.unmodifiableMap(this.synergyThreshold);
    }

    public Map<String, BigDecimal> getBaseValues() {
        return Collections.unmodifiableMap(this.baseValues);
    }

    public Map<String, BigDecimal> getIntrabandSynergyFactors() {
        return Collections.unmodifiableMap(this.intrabandSynergyFactors);
    }

    public BigDecimal getInterbandSynergyValue() {
        return this.interbandSynergyValue;
    }

    @Override
    public BigDecimal calculateValue(Bundle bundle) {
        if (bundle.getBundleEntries().isEmpty()) {
            return BigDecimal.ZERO;
        }
        HashMap<GenericGood, Integer> combined = new HashMap<GenericGood, Integer>();
        for (BundleEntry bundleEntry : bundle.getBundleEntries()) {
            GenericGood band;
            if (bundleEntry.getGood() instanceof SRVMLicense) {
                band = this.getWorld().getGenericDefinitionOf((License)bundleEntry.getGood());
                combined.put(band, combined.getOrDefault(band, 0) + 1);
                continue;
            }
            if (bundleEntry.getGood() instanceof SRVMBand) {
                band = bundleEntry.getGood();
                combined.put(band, combined.getOrDefault(band, 0) + bundleEntry.getAmount());
                continue;
            }
            throw new WrongConfigException("A good specified in a bundle is neither a SRVMLicense nor a SRVMBand!");
        }
        bundle = new Bundle(combined);
        BigDecimal bandValuesSum = BigDecimal.ZERO;
        int synergyBandCount = 0;
        for (BundleEntry entry : bundle.getBundleEntries()) {
            bandValuesSum = bandValuesSum.add(this.getBandValue((SRVMBand)entry.getGood(), entry.getAmount()));
            ++synergyBandCount;
        }
        if (synergyBandCount >= 2) {
            bandValuesSum = bandValuesSum.multiply(this.interbandSynergyValue);
        }
        return bandValuesSum;
    }

    private BigDecimal getBandValue(SRVMBand band, int quantity) {
        double lnApproximation;
        BigDecimal ln;
        int firstSummand = quantity > this.synergyThreshold.get(band.getName()) ? this.synergyThreshold.get(band.getName()) : quantity;
        BigDecimal minFraction = new BigDecimal(firstSummand - 1).divide(new BigDecimal(firstSummand), 5, RoundingMode.CEILING);
        BigDecimal synergyFactor = this.intrabandSynergyFactors.get(band.getName());
        BigDecimal secondSummand = minFraction.multiply(synergyFactor);
        int toLog = quantity - (this.synergyThreshold.get(band.getName()) - 1);
        BigDecimal thirdSummand = toLog <= 0 ? BigDecimal.ZERO : ((ln = new BigDecimal(lnApproximation = Math.log(toLog), new MathContext(5, RoundingMode.CEILING))).compareTo(BigDecimal.ZERO) >= 0 ? ln : BigDecimal.ZERO);
        BigDecimal firstFactor = new BigDecimal(firstSummand).add(secondSummand).add(thirdSummand);
        BigDecimal baseValue = this.baseValues.get(band.getName());
        return firstFactor.multiply(baseValue);
    }

    @Override
    public SRVMBidder drawSimilarBidder(RNGSupplier rngSupplier) {
        return new SRVMBidder((SRVMBidderSetup)this.getSetup(), this.getWorld(), this.getLongId(), this.getPopulation(), rngSupplier);
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> clazz, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
        if (clazz.isAssignableFrom(SizeBasedUniqueRandomXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new SizeBasedUniqueRandomXOR((Collection<? extends License>)this.world.getLicenses(), rngSupplier, this)));
        }
        if (clazz.isAssignableFrom(IncreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new IncreasingSizeOrderedXOR((Collection<? extends License>)this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(DecreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new DecreasingSizeOrderedXOR((Collection<? extends License>)this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(GenericSizeIncreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericFactory.getSizeOrderedGenericLang(true, this)));
        }
        if (clazz.isAssignableFrom(GenericSizeDecreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericFactory.getSizeOrderedGenericLang(false, this)));
        }
        if (clazz.isAssignableFrom(GenericPowersetIncreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericPowersetFactory.getSizeOrderedGenericLang(true, this)));
        }
        if (clazz.isAssignableFrom(GenericPowersetDecreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericPowersetFactory.getSizeOrderedGenericLang(false, this)));
        }
        if (clazz.isAssignableFrom(XORQRandomOrderSimple.class)) {
            return (T)((BiddingLanguage)clazz.cast(RandomOrderXORQFactory.getXORQRandomOrderSimpleLang(this)));
        }
        throw new UnsupportedBiddingLanguageException();
    }

    @Override
    public void refreshReference(World world) {
        Preconditions.checkArgument((world.getId() == this.getWorldId() ? 1 : 0) != 0);
        if (!(world instanceof SRVMWorld)) {
            throw new IllegalArgumentException("World is not of correct type");
        }
        this.world = (SRVMWorld)world;
    }

    public LinkedHashSet<Bundle> getBestBundles(Prices prices, int maxNumberOfBundles, boolean allowNegative) {
        throw new NotImplementedException("Demand Query to be implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SRVMBidder)) {
            return false;
        }
        SRVMBidder other = (SRVMBidder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BigDecimal this$bidderStrength = this.getBidderStrength();
        BigDecimal other$bidderStrength = other.getBidderStrength();
        if (this$bidderStrength == null ? other$bidderStrength != null : !((Object)this$bidderStrength).equals(other$bidderStrength)) {
            return false;
        }
        Map<String, Integer> this$synergyThreshold = this.getSynergyThreshold();
        Map<String, Integer> other$synergyThreshold = other.getSynergyThreshold();
        if (this$synergyThreshold == null ? other$synergyThreshold != null : !((Object)this$synergyThreshold).equals(other$synergyThreshold)) {
            return false;
        }
        Map<String, BigDecimal> this$baseValues = this.getBaseValues();
        Map<String, BigDecimal> other$baseValues = other.getBaseValues();
        if (this$baseValues == null ? other$baseValues != null : !((Object)this$baseValues).equals(other$baseValues)) {
            return false;
        }
        Map<String, BigDecimal> this$intrabandSynergyFactors = this.getIntrabandSynergyFactors();
        Map<String, BigDecimal> other$intrabandSynergyFactors = other.getIntrabandSynergyFactors();
        if (this$intrabandSynergyFactors == null ? other$intrabandSynergyFactors != null : !((Object)this$intrabandSynergyFactors).equals(other$intrabandSynergyFactors)) {
            return false;
        }
        BigDecimal this$interbandSynergyValue = this.getInterbandSynergyValue();
        BigDecimal other$interbandSynergyValue = other.getInterbandSynergyValue();
        return !(this$interbandSynergyValue == null ? other$interbandSynergyValue != null : !((Object)this$interbandSynergyValue).equals(other$interbandSynergyValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SRVMBidder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BigDecimal $bidderStrength = this.getBidderStrength();
        result = result * 59 + ($bidderStrength == null ? 43 : ((Object)$bidderStrength).hashCode());
        Map<String, Integer> $synergyThreshold = this.getSynergyThreshold();
        result = result * 59 + ($synergyThreshold == null ? 43 : ((Object)$synergyThreshold).hashCode());
        Map<String, BigDecimal> $baseValues = this.getBaseValues();
        result = result * 59 + ($baseValues == null ? 43 : ((Object)$baseValues).hashCode());
        Map<String, BigDecimal> $intrabandSynergyFactors = this.getIntrabandSynergyFactors();
        result = result * 59 + ($intrabandSynergyFactors == null ? 43 : ((Object)$intrabandSynergyFactors).hashCode());
        BigDecimal $interbandSynergyValue = this.getInterbandSynergyValue();
        result = result * 59 + ($interbandSynergyValue == null ? 43 : ((Object)$interbandSynergyValue).hashCode());
        return result;
    }
}

