/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowerset;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetIncreasing;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidder;

public class SizeOrderedGenericPowersetFactory {
    public static GenericPowerset getSizeOrderedGenericLang(boolean increasing, SRVMBidder bidder) throws UnsupportedBiddingLanguageException {
        ArrayList<SRVMBand> bands = new ArrayList<SRVMBand>((Collection<SRVMBand>)bidder.getWorld().getBands());
        if (increasing) {
            return new Increasing(bands, bidder);
        }
        return new Decreasing(bands, bidder);
    }

    private static final class Decreasing
    extends GenericPowersetDecreasing {
        private SRVMBidder bidder;

        protected Decreasing(List<SRVMBand> genericDefinitions, SRVMBidder bidder) throws UnsupportedBiddingLanguageException {
            super(genericDefinitions);
            this.bidder = bidder;
        }

        @Override
        public SRVMBidder getBidder() {
            return this.bidder;
        }
    }

    private static final class Increasing
    extends GenericPowersetIncreasing {
        private SRVMBidder bidder;

        protected Increasing(List<SRVMBand> genericDefinitions, SRVMBidder bidder) throws UnsupportedBiddingLanguageException {
            super(genericDefinitions);
            this.bidder = bidder;
        }

        @Override
        public SRVMBidder getBidder() {
            return this.bidder;
        }
    }
}

