/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.util.random;

import com.google.common.base.Preconditions;
import java.io.Serializable;

public final class IntegerInterval
implements Serializable {
    private static final long serialVersionUID = 3299198688422530105L;
    private final int minValue;
    private final int maxValue;

    public IntegerInterval(int minValue, int maxValue) {
        Preconditions.checkArgument((maxValue >= minValue ? 1 : 0) != 0);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public IntegerInterval(int singleValue) {
        this.minValue = singleValue;
        this.maxValue = singleValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public boolean isStrictlyPositive() {
        return this.minValue > 0;
    }

    public boolean isNonNegative() {
        return this.minValue >= 0;
    }

    public boolean isStrictlyNegative() {
        return this.maxValue < 0;
    }
}

