/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.util.random;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Random;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.IntegerInterval;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public class UniformJavaUtilRandomWrapper
implements UniformDistributionRNG {
    private static final long serialVersionUID = 4285241684660761136L;
    private Random rng;

    public UniformJavaUtilRandomWrapper() {
        this(new Date().getTime());
    }

    public UniformJavaUtilRandomWrapper(long seed) {
        this.rng = new Random(seed);
    }

    @Override
    public int nextInt() {
        return this.rng.nextInt();
    }

    @Override
    public int nextInt(int lowerLimit, int upperLimit) {
        if (upperLimit == Integer.MAX_VALUE) {
            --upperLimit;
        }
        return this.rng.nextInt(upperLimit - lowerLimit + 1) + lowerLimit;
    }

    @Override
    public int nextInt(IntegerInterval interval) {
        return this.nextInt(interval.getMinValue(), interval.getMaxValue());
    }

    @Override
    public double nextDouble() {
        return this.rng.nextDouble();
    }

    @Override
    public double nextDouble(double lowerLimit, double upperLimit) {
        return this.rng.nextDouble() * (upperLimit - lowerLimit) + lowerLimit;
    }

    @Override
    public long nextLong() {
        return this.rng.nextLong();
    }

    @Override
    public double nextDouble(DoubleInterval interval) {
        return this.nextDouble(interval.getMinValue(), interval.getMaxValue());
    }

    @Override
    public BigDecimal nextBigDecimal() {
        return BigDecimal.valueOf(this.nextDouble());
    }

    @Override
    public BigDecimal nextBigDecimal(double lowerLimit, double upperLimit) {
        return BigDecimal.valueOf(this.nextDouble(lowerLimit, upperLimit));
    }

    @Override
    public BigDecimal nextBigDecimal(DoubleInterval interval) {
        return BigDecimal.valueOf(this.nextDouble(interval));
    }

    @Override
    public int nextInt(int upperLimit) {
        return this.rng.nextInt(upperLimit);
    }
}

