/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.mechanism.domains;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.marketdesignresearch.mechlib.core.Allocation;
import org.marketdesignresearch.mechlib.core.BundleEntry;
import org.marketdesignresearch.mechlib.core.Domain;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.bidder.valuefunction.BundleValue;
import org.marketdesignresearch.mechlib.core.price.LinearPrices;
import org.marketdesignresearch.mechlib.core.price.Price;
import org.marketdesignresearch.mechlib.core.price.Prices;
import org.marketdesignresearch.mechlib.instrumentation.MipInstrumentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.opt.model.ModelMIP;

public abstract class ModelDomain<T extends SATSBidder>
implements Domain {
    private static final Logger log = LoggerFactory.getLogger(ModelDomain.class);
    private List<T> bidders;
    private transient Allocation efficientAllocation;
    private boolean generic;
    private int priceGenerationBidsPerBidder = 100;
    private int priceGenerationNumberOfWorldSamples = 100;
    private double priceGenerationFraction = 0.01;
    private long priceGenerationSeed = System.currentTimeMillis();
    private MipInstrumentation mipInstrumentation = MipInstrumentation.NO_OP;

    public abstract ModelMIP getMIP();

    public ModelDomain(List<T> bidders) {
        this.bidders = bidders;
    }

    public Allocation getEfficientAllocation() {
        if (!this.hasEfficientAllocationCalculated()) {
            this.getMIP().setMipInstrumentation(this.getMipInstrumentation());
            this.getMIP().setPurpose(MipInstrumentation.MipPurpose.ALLOCATION.name());
            this.efficientAllocation = this.getMIP().getAllocation();
        }
        return this.efficientAllocation;
    }

    public boolean hasEfficientAllocationCalculated() {
        return this.efficientAllocation != null;
    }

    public String getName() {
        return "SATS Domain";
    }

    public void setMipInstrumentation(MipInstrumentation mipInstrumentation) {
        this.mipInstrumentation = mipInstrumentation;
        this.getBidders().forEach(bidder -> bidder.setMipInstrumentation(mipInstrumentation));
    }

    public Prices proposeStartingPrices() {
        try {
            HashMap<Good, SimpleRegression> regressions = new HashMap<Good, SimpleRegression>();
            for (Good genericDefinition : this.getGoods()) {
                SimpleRegression regression = new SimpleRegression(false);
                regression.addData(0.0, 0.0);
                regressions.put(genericDefinition, regression);
            }
            JavaUtilRNGSupplier rngSupplier = new JavaUtilRNGSupplier(this.priceGenerationSeed);
            for (int i = 0; i < this.priceGenerationNumberOfWorldSamples; ++i) {
                List alternateBidders = this.bidders.stream().map(b -> b.drawSimilarBidder(rngSupplier)).collect(Collectors.toList());
                for (SATSBidder bidder : alternateBidders) {
                    Iterator<BundleValue> bidIterator = this.createPriceSamplingBiddingLanguage(rngSupplier, bidder, this.getPriceGenerationBidsPerBidder()).iterator();
                    while (bidIterator.hasNext()) {
                        BundleValue bid = bidIterator.next();
                        for (BundleEntry entry : bid.getBundle().getBundleEntries()) {
                            double y = bid.getAmount().doubleValue() * (double)entry.getAmount() / (double)bid.getBundle().getTotalAmount();
                            ((SimpleRegression)regressions.get(entry.getGood())).addData((double)entry.getAmount(), y);
                        }
                    }
                }
            }
            double min = Double.MAX_VALUE;
            HashMap<Good, Price> priceMap = new HashMap<Good, Price>();
            for (Map.Entry entry : regressions.entrySet()) {
                double y = ((SimpleRegression)entry.getValue()).predict(1.0);
                double price = y * this.priceGenerationFraction;
                log.info("{}:\nFound prediction of {}, setting starting price to {}.", new Object[]{entry.getKey(), y, price});
                priceMap.put((Good)entry.getKey(), new Price(BigDecimal.valueOf(price)));
                if (!(price > 0.0) || !(price < min)) continue;
                min = price;
            }
            for (Good def : regressions.keySet()) {
                if (((Price)priceMap.get(def)).getAmount().compareTo(BigDecimal.ZERO) >= 1) continue;
                priceMap.put(def, new Price(BigDecimal.valueOf(min)));
            }
            return new LinearPrices(priceMap);
        }
        catch (UnsupportedBiddingLanguageException e) {
            log.error("Tried to calculate sampled starting prices, but {} doesn't support the SizeBasedUniqueRandomXOR bidding language. Not setting any starting prices.", (Object)this);
            return null;
        }
    }

    public abstract BiddingLanguage createPriceSamplingBiddingLanguage(RNGSupplier var1, SATSBidder var2, int var3) throws UnsupportedBiddingLanguageException;

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelDomain)) {
            return false;
        }
        ModelDomain other = (ModelDomain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<T> this$bidders = this.getBidders();
        List<T> other$bidders = other.getBidders();
        if (this$bidders == null ? other$bidders != null : !((Object)this$bidders).equals(other$bidders)) {
            return false;
        }
        if (this.generic != other.generic) {
            return false;
        }
        if (this.getPriceGenerationBidsPerBidder() != other.getPriceGenerationBidsPerBidder()) {
            return false;
        }
        if (this.priceGenerationNumberOfWorldSamples != other.priceGenerationNumberOfWorldSamples) {
            return false;
        }
        if (Double.compare(this.priceGenerationFraction, other.priceGenerationFraction) != 0) {
            return false;
        }
        if (this.priceGenerationSeed != other.priceGenerationSeed) {
            return false;
        }
        MipInstrumentation this$mipInstrumentation = this.getMipInstrumentation();
        MipInstrumentation other$mipInstrumentation = other.getMipInstrumentation();
        return !(this$mipInstrumentation == null ? other$mipInstrumentation != null : !this$mipInstrumentation.equals(other$mipInstrumentation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelDomain;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $bidders = this.getBidders();
        result = result * 59 + ($bidders == null ? 43 : ((Object)$bidders).hashCode());
        result = result * 59 + (this.generic ? 79 : 97);
        result = result * 59 + this.getPriceGenerationBidsPerBidder();
        result = result * 59 + this.priceGenerationNumberOfWorldSamples;
        long $priceGenerationFraction = Double.doubleToLongBits(this.priceGenerationFraction);
        result = result * 59 + (int)($priceGenerationFraction >>> 32 ^ $priceGenerationFraction);
        long $priceGenerationSeed = this.priceGenerationSeed;
        result = result * 59 + (int)($priceGenerationSeed >>> 32 ^ $priceGenerationSeed);
        MipInstrumentation $mipInstrumentation = this.getMipInstrumentation();
        result = result * 59 + ($mipInstrumentation == null ? 43 : $mipInstrumentation.hashCode());
        return result;
    }

    public List<T> getBidders() {
        return this.bidders;
    }

    public void setPriceGenerationBidsPerBidder(int priceGenerationBidsPerBidder) {
        this.priceGenerationBidsPerBidder = priceGenerationBidsPerBidder;
    }

    protected int getPriceGenerationBidsPerBidder() {
        return this.priceGenerationBidsPerBidder;
    }

    public void setPriceGenerationNumberOfWorldSamples(int priceGenerationNumberOfWorldSamples) {
        this.priceGenerationNumberOfWorldSamples = priceGenerationNumberOfWorldSamples;
    }

    public void setPriceGenerationFraction(double priceGenerationFraction) {
        this.priceGenerationFraction = priceGenerationFraction;
    }

    public void setPriceGenerationSeed(long priceGenerationSeed) {
        this.priceGenerationSeed = priceGenerationSeed;
    }

    public MipInstrumentation getMipInstrumentation() {
        return this.mipInstrumentation;
    }
}

