/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.mrvm;

import com.google.common.base.Preconditions;
import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.core.util.math.ContinuousPiecewiseLinearFunction;
import org.spectrumauctions.sats.opt.domain.PartialMIP;
import org.spectrumauctions.sats.opt.domain.PiecewiseLinearPartialMIP;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMWorldPartialMip;

public abstract class MRVMBidderPartialMIP
extends PartialMIP {
    private static final String regionalOmegaPrefix = "aux_Omega";
    private static final String regionalCapacityFractionPrefix = "aux_c";
    private static final String regionalCapacityPrefix = "aux_cap";
    private static final String qualityPrefix = "aux_quality";
    private static final String regionalSVPrefix = "aux_sv";
    private Map<MRVMRegionsMap.Region, Variable> omegaVariables;
    private Map<MRVMRegionsMap.Region, Variable> cVariables;
    private Map<MRVMRegionsMap.Region, Map<MRVMBand, Variable>> capVariables;
    private Map<MRVMRegionsMap.Region, Variable> svVariables;
    protected final MRVMWorldPartialMip worldPartialMip;
    private final MRVMBidder bidder;
    private final double scaling;

    public MRVMBidderPartialMIP(MRVMBidder bidder, double scalingFactor, MRVMWorldPartialMip worldMip) {
        this.bidder = bidder;
        this.worldPartialMip = worldMip;
        this.scaling = scalingFactor;
        this.initVariables();
    }

    private void initVariables() {
        this.omegaVariables = this.createOmegaVariables();
        this.cVariables = this.createCVariables();
        this.capVariables = this.createCapVariables();
        this.svVariables = this.createSVVariables();
    }

    private Map<MRVMRegionsMap.Region, Variable> createSVVariables() {
        HashMap<MRVMRegionsMap.Region, Variable> result = new HashMap<MRVMRegionsMap.Region, Variable>();
        for (MRVMRegionsMap.Region region : this.bidder.getWorld().getRegionsMap().getRegions()) {
            String varName = regionalSVPrefix.concat(MRVMBidderPartialMIP.createIndex((SATSBidder)this.bidder, region));
            Variable var = new Variable(varName, VarType.DOUBLE, 0.0, 5.3687091E8);
            result.put(region, var);
        }
        return result;
    }

    private Map<MRVMRegionsMap.Region, Variable> createOmegaVariables() {
        HashMap<MRVMRegionsMap.Region, Variable> result = new HashMap<MRVMRegionsMap.Region, Variable>();
        for (MRVMRegionsMap.Region region : this.bidder.getWorld().getRegionsMap().getRegions()) {
            String varName = regionalOmegaPrefix.concat(MRVMBidderPartialMIP.createIndex((SATSBidder)this.bidder, region));
            Variable var = new Variable(varName, VarType.DOUBLE, 0.0, 5.3687091E8);
            result.put(region, var);
        }
        return result;
    }

    private Map<MRVMRegionsMap.Region, Variable> createCVariables() {
        HashMap<MRVMRegionsMap.Region, Variable> result = new HashMap<MRVMRegionsMap.Region, Variable>();
        for (MRVMRegionsMap.Region region : this.bidder.getWorld().getRegionsMap().getRegions()) {
            String varName = regionalCapacityFractionPrefix.concat(MRVMBidderPartialMIP.createIndex((SATSBidder)this.bidder, region));
            Variable var = new Variable(varName, VarType.DOUBLE, 0.0, 5.3687091E8);
            result.put(region, var);
        }
        return result;
    }

    private Map<MRVMRegionsMap.Region, Map<MRVMBand, Variable>> createCapVariables() {
        HashMap<MRVMRegionsMap.Region, Map<MRVMBand, Variable>> result = new HashMap<MRVMRegionsMap.Region, Map<MRVMBand, Variable>>();
        for (MRVMRegionsMap.Region region : this.bidder.getWorld().getRegionsMap().getRegions()) {
            HashMap<MRVMBand, Variable> bandCapacityVariables = new HashMap<MRVMBand, Variable>();
            for (MRVMBand band : this.bidder.getWorld().getBands()) {
                String varName = regionalCapacityPrefix.concat(MRVMBidderPartialMIP.createIndex(this.bidder, region, band));
                Variable var = new Variable(varName, VarType.DOUBLE, 0.0, 5.3687091E8);
                bandCapacityVariables.put(band, var);
            }
            result.put(region, Collections.unmodifiableMap(bandCapacityVariables));
        }
        return result;
    }

    Variable getOmegaVariable(MRVMRegionsMap.Region region) {
        Variable var = this.omegaVariables.get(region);
        Preconditions.checkNotNull((Object)var);
        return var;
    }

    Variable getCVariable(MRVMRegionsMap.Region region) {
        Variable var = this.cVariables.get(region);
        Preconditions.checkNotNull((Object)var);
        return var;
    }

    Variable getCapVariable(MRVMRegionsMap.Region region, MRVMBand band) {
        Variable var = this.capVariables.get(region).get(band);
        Preconditions.checkNotNull((Object)var);
        return var;
    }

    Variable getSVVariable(MRVMRegionsMap.Region region) {
        Variable var = this.svVariables.get(region);
        Preconditions.checkNotNull((Object)var);
        return var;
    }

    static String createIndex(SATSBidder bidder, MRVMRegionsMap.Region region) {
        return "_b" + bidder.getLongId() + ",r" + region.getId();
    }

    static String createIndex(SATSBidder bidder, MRVMBand band) {
        return "_b" + bidder.getLongId() + ",band_" + band.getName();
    }

    static String createIndex(SATSBidder bidder, MRVMRegionsMap.Region region, MRVMBand band) {
        return "_b" + bidder.getLongId() + ",r" + region.getId() + ",band_" + band.getName();
    }

    Set<PartialMIP> generateSVConstraints() {
        HashSet<PartialMIP> result = new HashSet<PartialMIP>();
        for (MRVMRegionsMap.Region region : this.bidder.getWorld().getRegionsMap().getRegions()) {
            Variable svInput = this.getCVariable(region);
            Variable svOutput = this.getSVVariable(region);
            ContinuousPiecewiseLinearFunction sv = this.bidder.svFunction(region);
            String helperVariablesPrefix = "sv_function_helpervar" + MRVMBidderPartialMIP.createIndex((SATSBidder)this.bidder, region) + "_";
            PiecewiseLinearPartialMIP piecewiseLinearPartialMIP = new PiecewiseLinearPartialMIP(sv, svInput, svOutput, helperVariablesPrefix);
            result.add(piecewiseLinearPartialMIP);
        }
        return result;
    }

    Set<Constraint> generateOmegaConstraints() {
        HashSet<Constraint> result = new HashSet<Constraint>();
        for (MRVMRegionsMap.Region region : this.bidder.getWorld().getRegionsMap().getRegions()) {
            double beta = this.bidder.getBeta(region).doubleValue();
            double population = region.getPopulation();
            double scaledFactor = beta * population / this.scaling;
            Constraint omega = new Constraint(CompareType.EQ, 0.0);
            omega.addTerm(-1.0, this.getOmegaVariable(region));
            omega.addTerm(scaledFactor, this.getSVVariable(region));
            result.add(omega);
        }
        return result;
    }

    Set<Constraint> generateCConstraints() {
        HashSet<Constraint> result = new HashSet<Constraint>();
        for (MRVMRegionsMap.Region region : this.bidder.getWorld().getRegionsMap().getRegions()) {
            Constraint regionalCConstraint = new Constraint(CompareType.EQ, 0.0);
            regionalCConstraint.addTerm(-1.0, this.getCVariable(region));
            for (MRVMBand band : this.bidder.getWorld().getBands()) {
                regionalCConstraint.addTerm(1.0, this.getCapVariable(region, band));
            }
            result.add(regionalCConstraint);
        }
        return result;
    }

    Set<PartialMIP> generateCapConstraints() {
        HashSet<PartialMIP> result = new HashSet<PartialMIP>();
        for (MRVMBand band : this.bidder.getWorld().getBands()) {
            ContinuousPiecewiseLinearFunction func = this.capLinearFunction(band);
            for (MRVMRegionsMap.Region region : this.bidder.getWorld().getRegionsMap().getRegions()) {
                Variable input = this.worldPartialMip.getXVariable(this.bidder, region, band);
                Variable output = this.getCapVariable(region, band);
                String auxiliaryVariableName = "aux_cap_helper_" + MRVMBidderPartialMIP.createIndex(this.bidder, region, band) + "_";
                PiecewiseLinearPartialMIP partialMip = new PiecewiseLinearPartialMIP(func, input, output, auxiliaryVariableName);
                result.add(partialMip);
            }
        }
        return result;
    }

    ContinuousPiecewiseLinearFunction capLinearFunction(MRVMBand band) {
        HashMap<BigDecimal, BigDecimal> breakpoints = new HashMap<BigDecimal, BigDecimal>();
        breakpoints.put(BigDecimal.ZERO, this.capAt(band, 0));
        BigDecimal lastSynergy = band.getSynergy(0);
        for (int quantity = 1; quantity <= band.getNumberOfLots(); ++quantity) {
            breakpoints.put(BigDecimal.valueOf(quantity), this.capAt(band, quantity));
        }
        ContinuousPiecewiseLinearFunction result = new ContinuousPiecewiseLinearFunction(breakpoints);
        return result;
    }

    private BigDecimal capAt(MRVMBand band, int quantity) {
        return MRVMWorld.capOfBand(band, quantity);
    }

    @Override
    public void appendVariablesToMip(IMIP mip) {
        super.appendVariablesToMip(mip);
        for (Variable variable : this.omegaVariables.values()) {
            mip.add(variable);
        }
        for (Variable variable : this.cVariables.values()) {
            mip.add(variable);
        }
        for (Variable variable : this.svVariables.values()) {
            mip.add(variable);
        }
        for (Map map : this.capVariables.values()) {
            for (Variable var : map.values()) {
                mip.add(var);
            }
        }
        for (PartialMIP partialMIP : this.generateCapConstraints()) {
            partialMIP.appendVariablesToMip(mip);
        }
        for (PartialMIP partialMIP : this.generateSVConstraints()) {
            partialMIP.appendVariablesToMip(mip);
        }
    }

    @Override
    public void appendConstraintsToMip(IMIP mip) {
        super.appendConstraintsToMip(mip);
        for (Constraint constraint : this.generateOmegaConstraints()) {
            mip.add(constraint);
        }
        for (Constraint constraint : this.generateCConstraints()) {
            mip.add(constraint);
        }
        for (PartialMIP partialMip : this.generateCapConstraints()) {
            partialMip.appendConstraintsToMip(mip);
        }
        for (PartialMIP partialMip : this.generateSVConstraints()) {
            partialMip.appendConstraintsToMip(mip);
        }
    }

    public double getScalingFactor() {
        return this.scaling;
    }
}

