/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.clt;

import java.io.File;
import java.io.IOException;
import java.util.List;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.spectrumauctions.sats.clt.BVMModelOptionParser;
import org.spectrumauctions.sats.clt.CATSModelOptionParser;
import org.spectrumauctions.sats.clt.CommandLineTool;
import org.spectrumauctions.sats.clt.GSVMModelOptionParser;
import org.spectrumauctions.sats.clt.LSVMModelOptionParser;
import org.spectrumauctions.sats.clt.MBVMModelOptionParser;
import org.spectrumauctions.sats.clt.MRVMModelOptionParser;
import org.spectrumauctions.sats.clt.Model;
import org.spectrumauctions.sats.clt.SRVMModelOptionParser;
import org.spectrumauctions.sats.core.api.BiddingLanguageEnum;
import org.spectrumauctions.sats.core.api.FileType;
import org.spectrumauctions.sats.core.api.IllegalConfigException;
import org.spectrumauctions.sats.core.api.ModelCreator;
import org.spectrumauctions.sats.core.api.PathResult;
import org.spectrumauctions.sats.core.api.SeedType;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;

public abstract class ModelOptionParser
extends OptionParser {
    public static String KEY_NUMBEROFBIDS = "bidsPerBidder";
    public static String KEY_MULTIPLEFILES = "multiplefiles";
    public static String KEY_ITERATOR = "iterator";
    public static String KEY_XORQ = "xorq";
    public static String KEY_BIDSPATH = "bidspath";
    public static String KEY_FILETYPE = "filetype";
    public static String KEY_MUTE = "mute";
    public static String KEY_SEED = "seed";
    private static File DEFAULTBIDSPATH = new File("bidfiles");

    public ModelOptionParser() {
        this.accepts("model", "Chose which model to use to generate your value function. Possible models: " + Model.allModels()).withRequiredArg().ofType(Model.class).required();
        this.accepts(KEY_NUMBEROFBIDS, "The number of atomic XOR bids per bidder to be written to the output file").withRequiredArg().ofType(Integer.class);
        this.accepts(KEY_MULTIPLEFILES, "Define if a separate file should be created for every bidder");
        this.accepts(KEY_ITERATOR, "Define an order in which the atomic bids should be returned. Options are: SIZE_INCREASING, SIZE_DECREASING, RANDOM, BIDDER_SPECIFIC, CATS_SPECIFIC").withRequiredArg().ofType(BiddingLanguageEnum.class);
        this.accepts(KEY_XORQ, "If flag is set, the returned bids are XOR-Q (And file format JSON)");
        this.accepts(CommandLineTool.KEY_HELP, "Gives a list of all possible Options. If used with the --model tag, the options for the specified model are also printed.");
        this.accepts(KEY_FILETYPE, "Decide for a File Type in which the bids are returned. Options are JSON and CATS").withRequiredArg().ofType(FileType.class);
        this.accepts(KEY_MUTE, "Disables notification about successful creation of files");
        this.accepts(KEY_SEED, "Specify the seeds used for the creation of the random instances. If two seeds (e.g. --seed 123 --seed 345) are passed, one is used for the creation of a non-bidder specific parameters (aka. world) and the second one for the bidders. If only one seed is defined, it is used to generate two seeds (for world and bidders)").withRequiredArg().ofType(Long.class);
        this.accepts(KEY_BIDSPATH, "Path to the folder where the bid files should be stored. Default is a folder ".concat(DEFAULTBIDSPATH.getName())).withRequiredArg().ofType(String.class);
    }

    protected abstract Model getModel();

    public abstract PathResult treatResult(String[] var1) throws IllegalConfigException, UnsupportedBiddingLanguageException, IOException;

    protected PathResult allModelsResultTreating(OptionSet options, ModelCreator.Builder builder) throws IllegalConfigException, UnsupportedBiddingLanguageException, IOException {
        boolean helpWasPrinted = CommandLineTool.printHelpIfRequested(options, this.getModel(), this);
        if (helpWasPrinted) {
            return null;
        }
        if (options.has(KEY_NUMBEROFBIDS)) {
            builder.setBidsPerBidder((Integer)options.valueOf(KEY_NUMBEROFBIDS));
        }
        if (options.has(KEY_MULTIPLEFILES)) {
            builder.setOneFile(false);
        } else {
            builder.setOneFile(true);
        }
        if (options.has(KEY_ITERATOR)) {
            builder.setLang((BiddingLanguageEnum)((Object)options.valueOf(KEY_ITERATOR)));
        } else if (options.valueOf("model").equals((Object)Model.CATS)) {
            builder.setLang(BiddingLanguageEnum.CATS_SPECIFIC);
        }
        if (options.has(KEY_SEED)) {
            List seeds = options.valuesOf(KEY_SEED);
            System.out.println(seeds);
            if (seeds.size() == 2) {
                builder.setSeedType(SeedType.INDIVIDUALSEED);
                builder.setWorldSeed((Long)seeds.get(0));
                builder.setPopulationSeed((Long)seeds.get(1));
            } else if (seeds.size() == 1) {
                builder.setSeedType(SeedType.SUPERSEED);
                builder.setSuperSeed((Long)seeds.get(0));
            } else {
                System.out.println("The number of provided seeds is not valid. Default seeds were used");
            }
        }
        if (options.has(KEY_XORQ)) {
            builder.setGeneric(true);
        } else {
            builder.setGeneric(false);
        }
        if (options.has(KEY_FILETYPE)) {
            builder.setFileType((FileType)((Object)options.valueOf(KEY_FILETYPE)));
        } else if (options.valueOf("model").equals((Object)Model.CATS)) {
            builder.setFileType(FileType.CATS);
        } else {
            builder.setFileType(FileType.JSON);
        }
        File outputFolder = DEFAULTBIDSPATH;
        if (options.has(KEY_BIDSPATH)) {
            outputFolder = new File((String)options.valueOf(KEY_BIDSPATH));
        }
        outputFolder.mkdir();
        return builder.build().generateResult(outputFolder);
    }

    public static ModelOptionParser createOptionParser(Model model) {
        switch (model) {
            case BVM: {
                return new BVMModelOptionParser();
            }
            case MBVM: {
                return new MBVMModelOptionParser();
            }
            case SRVM: {
                return new SRVMModelOptionParser();
            }
            case MRVM: {
                return new MRVMModelOptionParser();
            }
            case LSVM: {
                return new LSVMModelOptionParser();
            }
            case GSVM: {
                return new GSVMModelOptionParser();
            }
            case CATS: {
                return new CATSModelOptionParser();
            }
        }
        throw new IllegalArgumentException("Unknown Model, No request Parser Defined");
    }

    public static void printGeneralHelp() {
        ModelOptionParser dummy = new ModelOptionParser(){

            @Override
            public PathResult treatResult(String[] args) {
                throw new UnsupportedOperationException("Anonymous class only to be used for help printing");
            }

            @Override
            protected Model getModel() {
                return null;
            }
        };
        CommandLineTool.printHelp("all models", dummy);
    }
}

