/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.api;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import org.spectrumauctions.sats.core.api.BiddingLanguageEnum;
import org.spectrumauctions.sats.core.api.FileType;
import org.spectrumauctions.sats.core.api.IllegalConfigException;
import org.spectrumauctions.sats.core.api.PathResult;
import org.spectrumauctions.sats.core.api.SeedType;
import org.spectrumauctions.sats.core.bidfile.FileWriter;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.model.DefaultModel;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.util.file.FilePathUtils;

public abstract class ModelCreator {
    private final boolean oneFile;
    private final FileType fileType;
    private final boolean generic;
    private final int bidsPerBidder;
    private final long worldSeed;
    private final long populationSeed;
    private final BiddingLanguageEnum lang;
    private final boolean storeWorldSerialization;
    private SeedType seedType;
    private long superSeed;

    protected ModelCreator(Builder builder) {
        this.oneFile = builder.oneFile;
        this.fileType = builder.fileType;
        this.generic = builder.generic;
        this.bidsPerBidder = builder.bidsPerBidder;
        this.seedType = builder.seedType;
        this.superSeed = builder.superSeed;
        this.worldSeed = builder.worldSeed;
        this.populationSeed = builder.populationSeed;
        this.storeWorldSerialization = builder.storeWorldSerialization;
        this.lang = builder.lang;
    }

    public boolean isOneFile() {
        return this.oneFile;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public int getBidsPerBidder() {
        return this.bidsPerBidder;
    }

    public long getWorldSeed() {
        return this.worldSeed;
    }

    public long getPopulationSeed() {
        return this.populationSeed;
    }

    public boolean isStoreWorldSerialization() {
        return this.storeWorldSerialization;
    }

    public abstract PathResult generateResult(File var1) throws UnsupportedBiddingLanguageException, IOException, IllegalConfigException;

    protected PathResult appendTopLevelParamsAndSolve(DefaultModel<?, ?> model, File outputFolder) throws UnsupportedBiddingLanguageException, IOException, IllegalConfigException {
        List<?> bidders;
        if (this.seedType == SeedType.INDIVIDUALSEED) {
            bidders = model.createNewWorldAndPopulation(this.worldSeed, this.populationSeed);
        } else if (this.seedType == SeedType.NOSEED) {
            bidders = model.createNewWorldAndPopulation();
        } else if (this.seedType == SeedType.SUPERSEED) {
            bidders = model.createNewWorldAndPopulation(this.superSeed);
        } else {
            throw new IllegalConfigException("Seed type unknown");
        }
        FileWriter writer = FileType.getFileWriter(this.fileType, outputFolder);
        FilePathUtils filePathUtils = FilePathUtils.getInstance();
        File instanceFolder = filePathUtils.worldFolderPath(((SATSBidder)bidders.stream().findAny().orElseThrow(NoSuchElementException::new)).getWorldId());
        if (this.generic) {
            Class<? extends BiddingLanguage> langClass = BiddingLanguageEnum.getXORQLanguage(this.lang);
            if (this.oneFile) {
                ArrayList<BiddingLanguage> languages = new ArrayList<BiddingLanguage>();
                for (SATSBidder bidder : bidders) {
                    if (this.seedType == SeedType.SUPERSEED) {
                        languages.add(bidder.getValueFunction(langClass, this.superSeed));
                        continue;
                    }
                    languages.add(bidder.getValueFunction(langClass));
                }
                File valueFile = writer.writeMultiBidderXORQ(languages, this.bidsPerBidder, "satsvalue");
                PathResult result = new PathResult(this.storeWorldSerialization, instanceFolder);
                result.addValueFile(valueFile);
                return result;
            }
            ArrayList languages = new ArrayList();
            String zipId = String.valueOf(new Date().getTime());
            File folder = new File(writer.getFolder().getAbsolutePath().concat(File.separator).concat(zipId));
            folder.mkdir();
            for (SATSBidder bidder : bidders) {
                BiddingLanguage valueFunction = this.seedType == SeedType.SUPERSEED ? bidder.getValueFunction(langClass, this.superSeed) : bidder.getValueFunction(langClass);
                writer.writeSingleBidderXORQ(valueFunction, this.bidsPerBidder, zipId.concat(File.separator).concat("satsvalue"));
            }
            PathResult result = new PathResult(this.storeWorldSerialization, instanceFolder);
            result.addValueFile(folder);
            return result;
        }
        Class<? extends BiddingLanguage> langClass = BiddingLanguageEnum.getXORLanguage(this.lang);
        if (this.oneFile) {
            ArrayList<BiddingLanguage> languages = new ArrayList<BiddingLanguage>();
            for (SATSBidder bidder : bidders) {
                if (this.seedType == SeedType.SUPERSEED) {
                    languages.add(bidder.getValueFunction(langClass, this.superSeed));
                    continue;
                }
                languages.add(bidder.getValueFunction(langClass));
            }
            File valueFile = writer.writeMultiBidderXOR(languages, this.bidsPerBidder, "satsvalue");
            PathResult result = new PathResult(this.storeWorldSerialization, instanceFolder);
            result.addValueFile(valueFile);
            return result;
        }
        String zipId = String.valueOf(new Date().getTime());
        File folder = new File(writer.getFolder().getAbsolutePath().concat(File.separator).concat(zipId));
        folder.mkdir();
        for (SATSBidder bidder : bidders) {
            BiddingLanguage language = this.seedType == SeedType.SUPERSEED ? bidder.getValueFunction(langClass, this.superSeed) : bidder.getValueFunction(langClass);
            writer.writeSingleBidderXOR(language, this.bidsPerBidder, zipId.concat(File.separator).concat("satsvalue"));
        }
        PathResult result = new PathResult(this.storeWorldSerialization, instanceFolder);
        result.addValueFile(folder);
        return result;
    }

    public static abstract class Builder {
        private BiddingLanguageEnum lang = BiddingLanguageEnum.RANDOM;
        private boolean storeWorldSerialization = false;
        private long populationSeed;
        private long superSeed;
        private long worldSeed;
        private SeedType seedType = SeedType.NOSEED;
        private int bidsPerBidder = 100;
        private boolean generic = false;
        private FileType fileType = FileType.CATS;
        private boolean oneFile = true;

        public abstract ModelCreator build();

        public boolean isStoreWorldSerialization() {
            return this.storeWorldSerialization;
        }

        public void setStoreWorldSerialization(boolean storeWorldSerialization) {
            if (storeWorldSerialization) {
                throw new UnsupportedOperationException("Storing through API not yet supported");
            }
            this.storeWorldSerialization = storeWorldSerialization;
        }

        public long getPopulationSeed() {
            return this.populationSeed;
        }

        public void setPopulationSeed(long populationSeed) {
            this.populationSeed = populationSeed;
        }

        public long getWorldSeed() {
            return this.worldSeed;
        }

        public void setWorldSeed(long worldSeed) {
            this.worldSeed = worldSeed;
        }

        public int getBidsPerBidder() {
            return this.bidsPerBidder;
        }

        public void setSuperSeed(long superSeed) {
            this.superSeed = superSeed;
        }

        public void setSeedType(SeedType seedType) {
            this.seedType = seedType;
        }

        public void setLang(BiddingLanguageEnum lang) {
            this.lang = lang;
        }

        public void setBidsPerBidder(int bidsPerBidder) throws IllegalConfigException {
            try {
                Preconditions.checkArgument((bidsPerBidder > 0 ? 1 : 0) != 0, (String)"%s is not a valid number of bids per bidder", (int)bidsPerBidder);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalConfigException(e.getMessage());
            }
            this.bidsPerBidder = bidsPerBidder;
        }

        public boolean isGeneric() {
            return this.generic;
        }

        public void setGeneric(boolean generic) {
            this.generic = generic;
        }

        public FileType getFileType() {
            return this.fileType;
        }

        public void setFileType(FileType fileType) {
            this.fileType = fileType;
        }

        public boolean isOneFile() {
            return this.oneFile;
        }

        public void setOneFile(boolean oneFile) {
            this.oneFile = oneFile;
        }
    }
}

