/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.BundleEntry;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.bidder.valuefunction.BundleValue;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericSetsPickN;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;

public abstract class GenericPowerset
implements BiddingLanguage {
    final Map<GenericGood, Integer> maxQuantities;
    final int maxBundleSize;

    protected GenericPowerset(List<? extends GenericGood> genericGoods) throws UnsupportedBiddingLanguageException {
        LinkedHashMap<GenericGood, Integer> orderedMap = new LinkedHashMap<GenericGood, Integer>();
        for (GenericGood genericGood : genericGoods) {
            orderedMap.put(genericGood, genericGood.getQuantity());
        }
        this.maxQuantities = Collections.unmodifiableMap(orderedMap);
        this.maxBundleSize = genericGoods.stream().mapToInt(GenericGood::getQuantity).sum();
        this.isFeasibleSize(orderedMap, this.maxBundleSize);
    }

    GenericPowerset(Map<? extends GenericGood, Integer> maxQuantities, int maxBundleSize) throws UnsupportedBiddingLanguageException {
        this.maxQuantities = Collections.unmodifiableMap(maxQuantities);
        this.maxBundleSize = maxBundleSize;
        this.isFeasibleSize(maxQuantities, maxBundleSize);
    }

    protected abstract void isFeasibleSize(Map<? extends GenericGood, Integer> var1, int var2) throws UnsupportedBiddingLanguageException;

    abstract class PowersetIterator
    implements Iterator<BundleValue> {
        int bundleSize;
        GenericSetsPickN<GenericGood> pickN;

        PowersetIterator() {
        }

        @Override
        public BundleValue next() {
            if (!this.pickN.hasNext()) {
                this.intiPickN();
            }
            Object quantities = this.pickN.next();
            HashSet<BundleEntry> bundleEntries = new HashSet<BundleEntry>();
            for (Map.Entry entry : quantities.entrySet()) {
                if ((Integer)entry.getValue() <= 0) continue;
                bundleEntries.add(new BundleEntry((Good)entry.getKey(), ((Integer)entry.getValue()).intValue()));
            }
            Bundle bundle = new Bundle(bundleEntries);
            return new BundleValue(GenericPowerset.this.getBidder().calculateValue(bundle), bundle);
        }

        abstract void intiPickN();
    }
}

