/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.xor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.bidder.valuefunction.BundleValue;
import org.spectrumauctions.sats.core.bidlang.xor.SizeOrderedXOR;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.SATSBidder;

public class IncreasingSizeOrderedXOR
extends SizeOrderedXOR {
    public IncreasingSizeOrderedXOR(Collection<? extends License> goods, SATSBidder bidder) {
        super(goods, bidder);
    }

    @Override
    public Iterator<BundleValue> iterator() {
        return new IncreasingIterator();
    }

    private class IncreasingIterator
    implements Iterator<BundleValue> {
        BigInteger index = BigInteger.ONE;
        BigInteger maxIntex;

        private IncreasingIterator() {
            this.maxIntex = BigInteger.valueOf(2L).pow(IncreasingSizeOrderedXOR.this.goods.size());
        }

        @Override
        public boolean hasNext() {
            return this.index.compareTo(this.maxIntex) < 0;
        }

        @Override
        public BundleValue next() {
            Bundle bundle = IncreasingSizeOrderedXOR.this.getBundle(this.index);
            this.index = this.index.add(BigInteger.ONE);
            return new BundleValue(IncreasingSizeOrderedXOR.this.getBidder().calculateValue(bundle), bundle);
        }
    }
}

