/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model;

import java.util.List;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public abstract class DefaultModel<W extends World, B extends SATSBidder> {
    public abstract W createWorld(RNGSupplier var1);

    public W createWorld(long seed) {
        return this.createWorld(new JavaUtilRNGSupplier(seed));
    }

    public W createWorld() {
        return this.createWorld(new JavaUtilRNGSupplier());
    }

    public abstract List<B> createPopulation(W var1, RNGSupplier var2);

    public List<B> createNewWorldAndPopulation() {
        return this.createNewWorldAndPopulation(new JavaUtilRNGSupplier());
    }

    public List<B> createNewWorldAndPopulation(long seed) {
        return this.createNewWorldAndPopulation(seed, seed + 1L);
    }

    @Deprecated
    public List<B> createNewWorldAndPopulation(RNGSupplier rngSupplier) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        JavaUtilRNGSupplier worldSupplier = new JavaUtilRNGSupplier(rng.nextLong());
        JavaUtilRNGSupplier populationSupplier = new JavaUtilRNGSupplier(rng.nextLong());
        return this.createNewWorldAndPopulation(worldSupplier, populationSupplier);
    }

    @Deprecated
    public List<B> createNewWorldAndPopulation(long worldSeed, long populationSeed) {
        return this.createNewWorldAndPopulation(new JavaUtilRNGSupplier(worldSeed), new JavaUtilRNGSupplier(populationSeed));
    }

    public List<B> createNewWorldAndPopulation(RNGSupplier worldRNG, RNGSupplier populationRNG) {
        W world = this.createWorld(worldRNG);
        return this.createPopulation(world, populationRNG);
    }

    public List<B> createNewPopulation(W world, long populationSeed) {
        return this.createPopulation(world, new JavaUtilRNGSupplier(populationSeed));
    }

    public List<B> createNewPopulation(W world) {
        return this.createPopulation(world, new JavaUtilRNGSupplier());
    }
}

