/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.bidder.Bidder;
import org.marketdesignresearch.mechlib.core.bidder.strategy.DefaultStrategyHandler;
import org.marketdesignresearch.mechlib.core.bidder.strategy.InteractionStrategy;
import org.marketdesignresearch.mechlib.instrumentation.MipInstrumentation;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.model.BidderSetup;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.util.instancehandling.InstanceHandler;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public abstract class SATSBidder
implements Bidder,
Serializable {
    private static final long serialVersionUID = 3424512863538320455L;
    private final String setupType;
    private final UUID uuid;
    private final long population;
    private final long id;
    private final long worldId;
    private final transient BidderSetup setup;
    protected static final double DEFAULT_DEMAND_QUERY_EPSILON = 1.0E-10;
    protected static final double DEFAULT_DEMAND_QUERY_TIME_LIMIT = 600.0;
    private Map<Class<? extends InteractionStrategy>, InteractionStrategy> strategies = new HashMap<Class<? extends InteractionStrategy>, InteractionStrategy>();
    private MipInstrumentation mipInstrumentation = MipInstrumentation.NO_OP;

    protected SATSBidder(BidderSetup setup, long population, long id, long worldId) {
        this.uuid = UUID.randomUUID();
        this.setup = setup;
        this.setupType = setup.getSetupName();
        this.id = id;
        this.population = population;
        this.worldId = worldId;
    }

    public long getLongId() {
        return this.id;
    }

    public UUID getId() {
        return this.uuid;
    }

    public String getName() {
        return String.valueOf(this.id);
    }

    public String toString() {
        return "SATSBidder{" + this.getDescription() + "}";
    }

    public String getDescription() {
        return this.getShortDescription();
    }

    public String getShortDescription() {
        return this.getSetupType() + ": " + this.getName();
    }

    public String getSetupType() {
        return this.setupType;
    }

    public abstract BigDecimal calculateValue(Bundle var1);

    public List<BigDecimal> calculateValues(List<Bundle> bundles) {
        return bundles.parallelStream().map(this::calculateValue).collect(Collectors.toList());
    }

    public BigDecimal getValue(Bundle bundle, boolean ignoreAllocationLimits) {
        Preconditions.checkArgument((ignoreAllocationLimits || this.getAllocationLimit().validate(bundle) ? 1 : 0) != 0);
        return this.calculateValue(bundle);
    }

    public <T extends BiddingLanguage> T getValueFunction(Class<T> type) throws UnsupportedBiddingLanguageException {
        return this.getValueFunction(type, new Date().getTime());
    }

    public <T extends BiddingLanguage> T getValueFunction(Class<T> type, long seed) throws UnsupportedBiddingLanguageException {
        return this.getValueFunction(type, new JavaUtilRNGSupplier(seed));
    }

    public abstract <T extends BiddingLanguage> T getValueFunction(Class<T> var1, RNGSupplier var2) throws UnsupportedBiddingLanguageException;

    public long getPopulation() {
        return this.population;
    }

    public abstract World getWorld();

    protected void store() {
        InstanceHandler.getDefaultHandler().writeBidder(this);
    }

    public abstract void refreshReference(World var1);

    public long getWorldId() {
        return this.worldId;
    }

    public abstract SATSBidder drawSimilarBidder(RNGSupplier var1);

    protected BidderSetup getSetup() {
        return this.setup;
    }

    public void setStrategy(InteractionStrategy strategy) {
        strategy.setBidder((Bidder)this);
        strategy.getTypes().forEach(t -> this.strategies.put((Class<? extends InteractionStrategy>)t, strategy));
    }

    public <T extends InteractionStrategy> T getStrategy(Class<T> type) {
        if (!this.strategies.containsKey(type)) {
            this.setStrategy(DefaultStrategyHandler.defaultStrategy(type));
        }
        return (T)this.strategies.get(type);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SATSBidder)) {
            return false;
        }
        SATSBidder other = (SATSBidder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$setupType = this.setupType;
        String other$setupType = other.setupType;
        if (this$setupType == null ? other$setupType != null : !this$setupType.equals(other$setupType)) {
            return false;
        }
        return this.id == other.id;
    }

    protected boolean canEqual(Object other) {
        return other instanceof SATSBidder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $setupType = this.setupType;
        result = result * 59 + ($setupType == null ? 43 : $setupType.hashCode());
        long $id = this.id;
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public MipInstrumentation getMipInstrumentation() {
        return this.mipInstrumentation;
    }

    public void setMipInstrumentation(MipInstrumentation mipInstrumentation) {
        this.mipInstrumentation = mipInstrumentation;
    }
}

