/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm;

import java.util.ArrayList;
import java.util.List;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.model.IncompatibleWorldException;
import org.spectrumauctions.sats.core.model.bvm.BMLicense;
import org.spectrumauctions.sats.core.model.bvm.BMWorld;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public class BMBand
extends GenericGood {
    private static final long serialVersionUID = 1156082993361102068L;
    private final List<BMLicense> licenses;
    private transient BMWorld world;

    public BMBand(BMWorld world, String name, int numberOfLicenses, int licenseCounter, RNGSupplier rngSupplier) {
        super(name, world.getId());
        this.world = world;
        this.licenses = new ArrayList<BMLicense>();
        for (int i = 0; i < numberOfLicenses; ++i) {
            this.licenses.add(new BMLicense(licenseCounter++, this, rngSupplier));
        }
    }

    @Override
    public BMWorld getWorld() {
        return this.world;
    }

    public List<BMLicense> containedGoods() {
        return this.licenses;
    }

    @Override
    public int getQuantity() {
        return this.licenses.size();
    }

    private void setWorld(BMWorld world) {
        if (this.getWorldId() != world.getId()) {
            throw new IncompatibleWorldException("The stored worldId does not represent the passed world reference");
        }
        this.world = world;
    }

    public void refreshFieldBackReferences(BMWorld world) {
        this.setWorld(world);
        for (BMLicense license : this.licenses) {
            license.refreshFieldBackReferences(this);
        }
    }

    public boolean isPartOf(BMLicense license) {
        return license != null && license.getBand().equals(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BMBand)) {
            return false;
        }
        BMBand other = (BMBand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<BMLicense> this$licenses = this.licenses;
        List<BMLicense> other$licenses = other.licenses;
        return !(this$licenses == null ? other$licenses != null : !((Object)this$licenses).equals(other$licenses));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BMBand;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<BMLicense> $licenses = this.licenses;
        result = result * 59 + ($licenses == null ? 43 : ((Object)$licenses).hashCode());
        return result;
    }
}

