/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.BundleEntry;
import org.marketdesignresearch.mechlib.core.price.Prices;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeIncreasing;
import org.spectrumauctions.sats.core.bidlang.generic.SimpleRandomOrder.XORQRandomOrderSimple;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetIncreasing;
import org.spectrumauctions.sats.core.bidlang.xor.DecreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.IncreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.SizeBasedUniqueRandomXOR;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.model.IncompatibleWorldException;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.WrongConfigException;
import org.spectrumauctions.sats.core.model.bvm.BMBand;
import org.spectrumauctions.sats.core.model.bvm.BMBidderSetup;
import org.spectrumauctions.sats.core.model.bvm.BMLicense;
import org.spectrumauctions.sats.core.model.bvm.BMWorld;
import org.spectrumauctions.sats.core.model.bvm.RandomOrderXORQFactory;
import org.spectrumauctions.sats.core.model.bvm.SizeOrderedGenericFactory;
import org.spectrumauctions.sats.core.model.bvm.SizeOrderedGenericPowersetFactory;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public final class BMBidder
extends SATSBidder {
    private static final Logger logger = LogManager.getLogger(BMBidder.class);
    private static final long serialVersionUID = 3132260871321701148L;
    private transient BMWorld world;
    private final HashMap<String, Map<Integer, BigDecimal>> synergyFactors;
    private final HashMap<String, BigDecimal> baseValues;
    private final HashMap<String, Integer> positiveValueThreshold;

    public BMBidder(long population, int bidderId, BMWorld world, BMBidderSetup setup, UniformDistributionRNG rng) {
        super(setup, population, bidderId, world.getId());
        this.world = world;
        HashMap<String, Map<Integer, BigDecimal>> synergyFactors = new HashMap<String, Map<Integer, BigDecimal>>();
        HashMap<String, BigDecimal> baseValues = new HashMap<String, BigDecimal>();
        HashMap<String, Integer> positiveValueThreshold = new HashMap<String, Integer>();
        for (BMBand band : world.getBands()) {
            synergyFactors.put(band.getName(), setup.drawSynergyFactors(band, rng));
            baseValues.put(band.getName(), setup.drawBaseValue(band, rng));
            positiveValueThreshold.put(band.getName(), setup.drawPositiveValueThreshold(band, rng));
        }
        this.synergyFactors = synergyFactors;
        this.baseValues = baseValues;
        this.positiveValueThreshold = positiveValueThreshold;
        this.store();
    }

    public BigDecimal synergyFactor(BMBand band, int quantity) {
        Preconditions.checkArgument((quantity >= 0 ? 1 : 0) != 0);
        if (quantity == 1) {
            return BigDecimal.ONE;
        }
        if (quantity == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal synFactor = this.synergyFactors.get(band.getName()).get(quantity);
        if (synFactor != null) {
            return synFactor;
        }
        return this.synergyFactor(band, quantity - 1);
    }

    public BigDecimal getBaseValue(BMBand band) {
        return this.baseValues.get(band.getName());
    }

    public int highestSynergyQuantity(BMBand band) {
        if (this.synergyFactors.get(band.getName()) == null) {
            return 1;
        }
        if (this.synergyFactors.get(band.getName()) == null || this.synergyFactors.get(band.getName()).isEmpty()) {
            return 1;
        }
        Integer result = Collections.max(this.synergyFactors.get(band.getName()).keySet());
        if (result == null || result < 1) {
            return 1;
        }
        return result;
    }

    @Override
    public SATSBidder drawSimilarBidder(RNGSupplier rngSupplier) {
        return new BMBidder(this.getPopulation(), (int)this.getLongId(), this.getWorld(), (BMBidderSetup)this.getSetup(), rngSupplier.getUniformDistributionRNG());
    }

    @Override
    public BMWorld getWorld() {
        return this.world;
    }

    private void setWorld(BMWorld world) {
        if (this.getWorldId() != world.getId()) {
            throw new IncompatibleWorldException("The stored worldId does not represent the passed world reference");
        }
        this.world = world;
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> clazz, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
        if (clazz.isAssignableFrom(SizeBasedUniqueRandomXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new SizeBasedUniqueRandomXOR(this.world.getLicenses(), rngSupplier, this)));
        }
        if (clazz.isAssignableFrom(IncreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new IncreasingSizeOrderedXOR(this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(DecreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new DecreasingSizeOrderedXOR(this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(GenericSizeIncreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericFactory.getSizeOrderedGenericLang(true, this)));
        }
        if (clazz.isAssignableFrom(GenericSizeDecreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericFactory.getSizeOrderedGenericLang(false, this)));
        }
        if (clazz.isAssignableFrom(GenericPowersetIncreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericPowersetFactory.getSizeOrderedGenericLang(true, this)));
        }
        if (clazz.isAssignableFrom(GenericPowersetDecreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericPowersetFactory.getSizeOrderedGenericLang(false, this)));
        }
        if (clazz.isAssignableFrom(XORQRandomOrderSimple.class)) {
            return (T)((BiddingLanguage)clazz.cast(RandomOrderXORQFactory.getXORQRandomOrderSimpleLang(this)));
        }
        throw new UnsupportedBiddingLanguageException();
    }

    @Override
    public void refreshReference(World world) {
        if (!(world instanceof BMWorld)) {
            throw new IncompatibleWorldException("Wrong world class");
        }
        this.setWorld((BMWorld)world);
    }

    @Override
    public BigDecimal calculateValue(Bundle bundle) {
        GenericGood band;
        if (bundle.getBundleEntries().isEmpty()) {
            return BigDecimal.ZERO;
        }
        HashMap<GenericGood, Integer> combined = new HashMap<GenericGood, Integer>();
        for (BundleEntry bundleEntry : bundle.getBundleEntries()) {
            int currentValue;
            if (bundleEntry.getGood() instanceof BMLicense) {
                band = this.getWorld().getGenericDefinitionOf((License)bundleEntry.getGood());
                currentValue = combined.getOrDefault(band, 0);
                if (currentValue >= this.positiveValueThreshold.get(band.getName())) continue;
                combined.put(band, currentValue + 1);
                continue;
            }
            if (bundleEntry.getGood() instanceof BMBand) {
                band = bundleEntry.getGood();
                currentValue = combined.getOrDefault(band, 0);
                if (currentValue >= this.positiveValueThreshold.get(band.getName())) continue;
                combined.put(band, currentValue + bundleEntry.getAmount());
                continue;
            }
            throw new WrongConfigException("A good specified in a bundle is neither a BMLicense nor a BMBand!");
        }
        bundle = new Bundle(combined);
        for (BundleEntry entry : bundle.getBundleEntries()) {
            Preconditions.checkArgument((boolean)(entry.getGood() instanceof BMBand));
            band = (BMBand)entry.getGood();
            Preconditions.checkArgument((boolean)((BMBand)band).getWorld().equals(this.getWorld()), (Object)("Band is not from this world" + band.getName()));
            Preconditions.checkArgument((entry.getAmount() >= 0 ? 1 : 0) != 0, (Object)("Quantity must not be negative. Band:" + band.getName() + "\t Licenses:" + entry.getAmount()));
            Preconditions.checkArgument((entry.getAmount() <= ((BMBand)band).getQuantity() ? 1 : 0) != 0, (Object)("Specified too many licenses for this band" + band.getName() + "\t Licenses:" + entry.getAmount()));
        }
        BigDecimal value = BigDecimal.ZERO;
        for (BundleEntry entry : bundle.getBundleEntries()) {
            BigDecimal synergyFactor;
            BMBand band2 = (BMBand)entry.getGood();
            int synergyQuantitiyLimit = this.highestSynergyQuantity(band2);
            BigDecimal baseValue = this.getBaseValue(band2);
            if (entry.getAmount() > synergyQuantitiyLimit) {
                synergyFactor = this.synergyFactor(band2, synergyQuantitiyLimit);
                value = value.add(new BigDecimal(synergyQuantitiyLimit).multiply(synergyFactor).multiply(baseValue));
                value = value.add(baseValue.multiply(new BigDecimal(entry.getAmount() - synergyQuantitiyLimit)));
                continue;
            }
            synergyFactor = this.synergyFactor(band2, entry.getAmount());
            value = value.add(new BigDecimal(entry.getAmount()).multiply(synergyFactor).multiply(baseValue));
        }
        return value;
    }

    public LinkedHashSet<Bundle> getBestBundles(Prices prices, int maxNumberOfBundles, boolean allowNegative) {
        throw new NotImplementedException("Demand Query to be implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BMBidder)) {
            return false;
        }
        BMBidder other = (BMBidder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HashMap<String, Map<Integer, BigDecimal>> this$synergyFactors = this.synergyFactors;
        HashMap<String, Map<Integer, BigDecimal>> other$synergyFactors = other.synergyFactors;
        if (this$synergyFactors == null ? other$synergyFactors != null : !((Object)this$synergyFactors).equals(other$synergyFactors)) {
            return false;
        }
        HashMap<String, BigDecimal> this$baseValues = this.baseValues;
        HashMap<String, BigDecimal> other$baseValues = other.baseValues;
        if (this$baseValues == null ? other$baseValues != null : !((Object)this$baseValues).equals(other$baseValues)) {
            return false;
        }
        HashMap<String, Integer> this$positiveValueThreshold = this.positiveValueThreshold;
        HashMap<String, Integer> other$positiveValueThreshold = other.positiveValueThreshold;
        return !(this$positiveValueThreshold == null ? other$positiveValueThreshold != null : !((Object)this$positiveValueThreshold).equals(other$positiveValueThreshold));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BMBidder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        HashMap<String, Map<Integer, BigDecimal>> $synergyFactors = this.synergyFactors;
        result = result * 59 + ($synergyFactors == null ? 43 : ((Object)$synergyFactors).hashCode());
        HashMap<String, BigDecimal> $baseValues = this.baseValues;
        result = result * 59 + ($baseValues == null ? 43 : ((Object)$baseValues).hashCode());
        HashMap<String, Integer> $positiveValueThreshold = this.positiveValueThreshold;
        result = result * 59 + ($positiveValueThreshold == null ? 43 : ((Object)$positiveValueThreshold).hashCode());
        return result;
    }
}

