/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.gsvm;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.HashMap;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimit;
import org.spectrumauctions.sats.core.model.BidderSetup;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidder;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public abstract class GSVMBidderSetup
extends BidderSetup {
    private final DoubleInterval lowNationalValueInterval;
    private final DoubleInterval highNationalValueInterval;
    private final DoubleInterval regionalValueInterval;
    private final int activityLimitOverride;

    GSVMBidderSetup(Builder builder) {
        super(builder);
        this.lowNationalValueInterval = builder.lowNationalValueInterval;
        this.highNationalValueInterval = builder.highNationalValueInterval;
        this.regionalValueInterval = builder.regionalValueInterval;
        this.activityLimitOverride = builder.activityLimitOverride;
    }

    public DoubleInterval getLowNationalValueInterval() {
        return this.lowNationalValueInterval;
    }

    public DoubleInterval getHighNationalValueInterval() {
        return this.highNationalValueInterval;
    }

    public DoubleInterval getRegionalValueInterval() {
        return this.regionalValueInterval;
    }

    abstract HashMap<Long, BigDecimal> drawValues(RNGSupplier var1, GSVMBidder var2);

    public abstract AllocationLimit getAllocationLimit(GSVMBidder var1);

    BigDecimal getValueDependingOnRegion(UniformDistributionRNG rng, int position, int size) {
        if (position < size / 3 * 2) {
            return rng.nextBigDecimal(this.lowNationalValueInterval);
        }
        if (position < size / 3 * 4) {
            return rng.nextBigDecimal(this.highNationalValueInterval);
        }
        return rng.nextBigDecimal(this.lowNationalValueInterval);
    }

    public int getActivityLimitOverride() {
        return this.activityLimitOverride;
    }

    protected static abstract class Builder
    extends BidderSetup.Builder {
        protected DoubleInterval lowNationalValueInterval;
        protected DoubleInterval highNationalValueInterval;
        protected DoubleInterval regionalValueInterval;
        protected int activityLimitOverride = -1;

        protected Builder(String setupName, int numberOfBidders, DoubleInterval lnvi, DoubleInterval hnvi, DoubleInterval rvi) {
            super(setupName, numberOfBidders);
            this.lowNationalValueInterval = lnvi;
            this.highNationalValueInterval = hnvi;
            this.regionalValueInterval = rvi;
        }

        public void setLowNationalValueInterval(DoubleInterval iv) {
            Preconditions.checkArgument((iv.getMinValue() >= 0.0 ? 1 : 0) != 0);
            this.lowNationalValueInterval = iv;
        }

        public void setHighNationalValueInterval(DoubleInterval iv) {
            Preconditions.checkArgument((iv.getMinValue() >= 0.0 ? 1 : 0) != 0);
            this.highNationalValueInterval = iv;
        }

        @Override
        public abstract GSVMBidderSetup build();

        public void setActivityLimitOverride(int activityLimitOverride) {
            this.activityLimitOverride = activityLimitOverride;
        }
    }
}

