/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.gsvm;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.HashMap;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimit;
import org.marketdesignresearch.mechlib.core.allocationlimits.BundleSizeAllocationLimit;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidder;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidderSetup;
import org.spectrumauctions.sats.core.model.gsvm.GSVMLicense;
import org.spectrumauctions.sats.core.model.gsvm.GSVMWorld;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public class GSVMRegionalBidderSetup
extends GSVMBidderSetup {
    private GSVMRegionalBidderSetup(GSVMBidderSetup.Builder builder) {
        super(builder);
    }

    @Override
    HashMap<Long, BigDecimal> drawValues(RNGSupplier rngSupplier, GSVMBidder bidder) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        GSVMWorld world = bidder.getWorld();
        HashMap<Long, BigDecimal> values = new HashMap<Long, BigDecimal>();
        for (GSVMLicense license : world.getNationalCircle().getLicenses()) {
            if (!this.isInProximity(license.getPosition(), bidder.getBidderPosition(), world.getSize(), true)) continue;
            values.put(license.getLongId(), this.getValueDependingOnRegion(rng, license.getPosition(), world.getSize()));
        }
        for (GSVMLicense license : world.getRegionalCircle().getLicenses()) {
            if (!this.isInProximity(license.getPosition(), bidder.getBidderPosition(), world.getSize(), false)) continue;
            values.put(license.getLongId(), rng.nextBigDecimal(this.getRegionalValueInterval()));
        }
        return values;
    }

    @Override
    public AllocationLimit getAllocationLimit(GSVMBidder bidder) {
        if (bidder.getWorld().isLegacyGSVM()) {
            return AllocationLimit.NO;
        }
        if (this.getActivityLimitOverride() > -1) {
            return new BundleSizeAllocationLimit(this.getActivityLimitOverride(), bidder.getWorld().getLicenses());
        }
        return new BundleSizeAllocationLimit((int)Math.round((double)bidder.getBaseValues().size() * 2.0 / 3.0), bidder.getWorld().getLicenses());
    }

    private boolean isInProximity(int licensePosition, int bidderPosition, int size, boolean isNationalCircle) {
        int factor = isNationalCircle ? 1 : 2;
        bidderPosition = bidderPosition * 2 / factor;
        return licensePosition == bidderPosition || licensePosition == (bidderPosition + 1 / factor) % (size * 2 / factor) || licensePosition == (bidderPosition + 2 / factor) % (size * 2 / factor) || licensePosition == (bidderPosition + 3 / factor) % (size * 2 / factor);
    }

    public static class Builder
    extends GSVMBidderSetup.Builder {
        public Builder() {
            super("Regional Bidder Setup", 6, new DoubleInterval(0.0, 20.0), new DoubleInterval(0.0, 40.0), new DoubleInterval(0.0, 20.0));
        }

        public void setRegionalValueInterval(DoubleInterval iv) {
            Preconditions.checkArgument((iv.getMinValue() >= 0.0 ? 1 : 0) != 0);
            this.regionalValueInterval = iv;
        }

        @Override
        public GSVMRegionalBidderSetup build() {
            return new GSVMRegionalBidderSetup(this);
        }
    }
}

