/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.lsvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.spectrumauctions.sats.core.model.lsvm.LSVMLicense;
import org.spectrumauctions.sats.core.model.lsvm.LSVMWorld;
import org.spectrumauctions.sats.core.model.lsvm.LSVMWorldSetup;
import org.spectrumauctions.sats.core.util.PreconditionUtils;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public class LSVMGrid
implements Serializable {
    private static final long serialVersionUID = -3752536748200949347L;
    private final LSVMLicense[][] licenses;
    private final long worldId;
    private final int numberOfRows;
    private final int numberOfColumns;
    private transient LSVMWorld world;
    private transient ImmutableList<LSVMLicense> licenseList = null;

    public LSVMGrid(LSVMWorld world, LSVMWorldSetup worldSetup, UniformDistributionRNG rng) {
        this.world = world;
        this.worldId = world.getId();
        this.numberOfRows = worldSetup.drawRowNumber(rng);
        this.numberOfColumns = worldSetup.drawColumnNumber(rng);
        PreconditionUtils.checkNotNegative(this.numberOfRows);
        PreconditionUtils.checkNotNegative(this.numberOfColumns);
        this.licenses = new LSVMLicense[this.numberOfRows][this.numberOfColumns];
        int id = 0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (int j = 0; j < this.numberOfColumns; ++j) {
                this.licenses[i][j] = new LSVMLicense(id++, i, j, world);
            }
        }
    }

    public ImmutableList<LSVMLicense> getLicenses() {
        if (this.licenseList == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < this.numberOfRows; ++i) {
                for (int j = 0; j < this.numberOfColumns; ++j) {
                    builder.add((Object)this.licenses[i][j]);
                }
            }
            this.licenseList = builder.build();
        }
        return this.licenseList;
    }

    void refreshFieldBackReferences(LSVMWorld world) {
        Preconditions.checkArgument((world.getId() == this.worldId ? 1 : 0) != 0);
        this.world = world;
        for (int i = 0; i < this.numberOfRows; ++i) {
            for (LSVMLicense license : this.licenses[i]) {
                license.refreshFieldBackReferences(this);
            }
        }
    }

    public LSVMWorld getWorld() {
        return this.world;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    LSVMLicense getLicense(int row, int column) {
        PreconditionUtils.checkNotNegative(row);
        PreconditionUtils.checkNotNegative(column);
        Preconditions.checkArgument((row < this.numberOfRows ? 1 : 0) != 0);
        Preconditions.checkArgument((column < this.numberOfColumns ? 1 : 0) != 0);
        return this.licenses[row][column];
    }

    List<LSVMLicense> getProximity(LSVMLicense center, int proximitySize) {
        LinkedHashSet<LSVMLicense> proximity = new LinkedHashSet<LSVMLicense>();
        proximity.add(center);
        HashSet<LSVMLicense> tmp = this.expand(proximity, center);
        for (int i = 0; i < proximitySize; ++i) {
            proximity.addAll(tmp);
            LinkedHashSet<LSVMLicense> tmp2 = new LinkedHashSet<LSVMLicense>();
            for (LSVMLicense license : tmp) {
                tmp2.addAll(this.expand(proximity, license));
            }
            tmp = tmp2;
        }
        return proximity.stream().collect(Collectors.toList());
    }

    private HashSet<LSVMLicense> expand(HashSet<LSVMLicense> proximity, LSVMLicense license) {
        LinkedHashSet<LSVMLicense> newLicenses = new LinkedHashSet<LSVMLicense>();
        if (license.getRowPosition() > 0 && !proximity.contains(this.getLicense(license.getRowPosition() - 1, license.getColumnPosition()))) {
            newLicenses.add(this.getLicense(license.getRowPosition() - 1, license.getColumnPosition()));
        }
        if (license.getColumnPosition() < this.getNumberOfColumns() - 1 && !proximity.contains(this.getLicense(license.getRowPosition(), license.getColumnPosition() + 1))) {
            newLicenses.add(this.getLicense(license.getRowPosition(), license.getColumnPosition() + 1));
        }
        if (license.getRowPosition() < this.getNumberOfRows() - 1 && !proximity.contains(this.getLicense(license.getRowPosition() + 1, license.getColumnPosition()))) {
            newLicenses.add(this.getLicense(license.getRowPosition() + 1, license.getColumnPosition()));
        }
        if (license.getColumnPosition() > 0 && !proximity.contains(this.getLicense(license.getRowPosition(), license.getColumnPosition() - 1))) {
            newLicenses.add(this.getLicense(license.getRowPosition(), license.getColumnPosition() - 1));
        }
        return newLicenses;
    }

    public boolean isNeighbor(LSVMLicense a, LSVMLicense b) {
        return a.getRowPosition() == b.getRowPosition() + 1 && a.getColumnPosition() == b.getColumnPosition() || a.getRowPosition() == b.getRowPosition() - 1 && a.getColumnPosition() == b.getColumnPosition() || a.getRowPosition() == b.getRowPosition() && a.getColumnPosition() + 1 == b.getColumnPosition() || a.getRowPosition() == b.getRowPosition() && a.getColumnPosition() - 1 == b.getColumnPosition();
    }

    private boolean hasNeighbor(LSVMLicense a, Set<LSVMLicense> set) {
        for (LSVMLicense b : set) {
            if (!this.isNeighbor(a, b)) continue;
            return true;
        }
        return false;
    }

    Set<Set<LSVMLicense>> getMaximallyConnectedSubpackages(Set<LSVMLicense> bundle) {
        HashSet<Set<LSVMLicense>> subpackages = new HashSet<Set<LSVMLicense>>();
        HashSet<LSVMLicense> copyOfBundle = new HashSet<LSVMLicense>(bundle);
        while (!copyOfBundle.isEmpty()) {
            LSVMLicense next = (LSVMLicense)copyOfBundle.iterator().next();
            HashSet<LSVMLicense> currentSet = new HashSet<LSVMLicense>();
            currentSet.add(next);
            Set<LSVMLicense> subpackage = this.addNeighbors(currentSet, copyOfBundle);
            copyOfBundle.removeAll(subpackage);
            subpackages.add(subpackage);
        }
        return subpackages;
    }

    private Set<LSVMLicense> addNeighbors(Set<LSVMLicense> currentSet, Set<LSVMLicense> possibleNeighbors) {
        if (currentSet.size() == possibleNeighbors.size()) {
            return currentSet;
        }
        HashSet<LSVMLicense> linkedLicenses = new HashSet<LSVMLicense>(currentSet);
        HashSet<LSVMLicense> unassigned = new HashSet<LSVMLicense>(possibleNeighbors);
        unassigned.removeAll(currentSet);
        for (LSVMLicense license : unassigned) {
            if (!this.hasNeighbor(license, currentSet)) continue;
            linkedLicenses.add(license);
            linkedLicenses.addAll(this.addNeighbors(linkedLicenses, possibleNeighbors));
        }
        return linkedLicenses;
    }
}

