/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import java.util.HashMap;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;
import org.jgrapht.graph.builder.GraphBuilder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorldSetup;

public class CanadianMap {
    private Map<Integer, MRVMWorldSetup.RegionSetup> regions;
    private static CanadianMap INSTANCE;

    public static CanadianMap getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CanadianMap();
        }
        return INSTANCE;
    }

    private CanadianMap() {
        this.initRegions();
    }

    protected void initRegions() {
        this.regions = new HashMap<Integer, MRVMWorldSetup.RegionSetup>();
        this.regions.put(1, new MRVMWorldSetup.RegionSetup(514711.0, 0.0, "Newfoundland and Labrador"));
        this.regions.put(2, new MRVMWorldSetup.RegionSetup(1061900.0, 0.0, "Nova Scotia and Prince Edward Island"));
        this.regions.put(3, new MRVMWorldSetup.RegionSetup(749623.0, 0.0, "New Brunswick"));
        this.regions.put(4, new MRVMWorldSetup.RegionSetup(1668504.0, 0.0, "Eastern Quebec"));
        this.regions.put(5, new MRVMWorldSetup.RegionSetup(5683127.0, 0.0, "Southern Quebec"));
        this.regions.put(6, new MRVMWorldSetup.RegionSetup(2347556.0, 0.0, "Eastern Ontario and Outaouais"));
        this.regions.put(7, new MRVMWorldSetup.RegionSetup(190271.0, 0.0, "Northern Quebec"));
        this.regions.put(8, new MRVMWorldSetup.RegionSetup(1.0091045E7, 0.0, "Southern Ontario"));
        this.regions.put(9, new MRVMWorldSetup.RegionSetup(773104.0, 0.0, "Northern Ontario"));
        this.regions.put(10, new MRVMWorldSetup.RegionSetup(1208253.0, 0.0, "Manitoba"));
        this.regions.put(11, new MRVMWorldSetup.RegionSetup(2059248.0, 0.0, "Saskatchewan (incl. Province)"));
        this.regions.put(12, new MRVMWorldSetup.RegionSetup(7297342.0, 0.0, "Alberta (incl. Province)"));
        this.regions.put(13, new MRVMWorldSetup.RegionSetup(4399805.0, 0.0, "British Columbia"));
        this.regions.put(14, new MRVMWorldSetup.RegionSetup(104625.0, 0.0, "Yukon, Northwest Territories and Nunavut"));
    }

    public Graph<MRVMWorldSetup.RegionSetup, DefaultEdge> createCanadianMapGraph() {
        SimpleGraph graph = new SimpleGraph(DefaultEdge.class);
        GraphBuilder builder = new GraphBuilder((Graph)graph);
        for (MRVMWorldSetup.RegionSetup r : this.regions.values()) {
            builder.addVertex((Object)r);
        }
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 1, 2);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 1, 4);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 1, 7);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 2, 3);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 3, 4);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 3, 5);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 4, 5);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 4, 7);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 5, 7);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 6, 8);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 6, 9);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 7, 9);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 8, 9);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 9, 10);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 10, 11);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 11, 12);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 11, 14);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 12, 13);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 12, 14);
        this.addAdjacency((GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>>)builder, 13, 14);
        return builder.build();
    }

    private void addAdjacency(GraphBuilder<MRVMWorldSetup.RegionSetup, DefaultEdge, Graph<MRVMWorldSetup.RegionSetup, DefaultEdge>> builder, int r1, int r2) {
        builder.addEdge((Object)this.regions.get(r1), (Object)this.regions.get(r2));
    }
}

