/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.model.IncompatibleWorldException;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public final class MRVMBand
extends GenericGood {
    private static final long serialVersionUID = -4482949789084377013L;
    private final BigDecimal baseCapacity;
    private final int numberOfLots;
    private final List<MRVMLicense> licenses;
    private final Map<Integer, BigDecimal> synergies;
    private transient MRVMWorld world;

    public static HashSet<MRVMBand> createBands(MRVMWorld world, MRVMWorldSetup worldSetup, MRVMRegionsMap regionsMap, UniformDistributionRNG rng) {
        Set<MRVMWorldSetup.BandSetup> bandSetups = worldSetup.getBandSetups();
        LinkedHashSet<MRVMBand> bands = new LinkedHashSet<MRVMBand>();
        int currentLicenseId = 0;
        for (MRVMWorldSetup.BandSetup bandSetup : bandSetups) {
            MRVMBand band = new MRVMBand(bandSetup, world, currentLicenseId, rng);
            currentLicenseId += band.getQuantity();
            bands.add(band);
        }
        return bands;
    }

    private MRVMBand(MRVMWorldSetup.BandSetup bandSetup, MRVMWorld world, int licenseStartId, UniformDistributionRNG rng) {
        super(bandSetup.getName(), world.getId());
        this.world = world;
        this.numberOfLots = bandSetup.drawNumberOfLots(rng);
        this.baseCapacity = bandSetup.drawBaseCapacity(rng);
        this.synergies = ImmutableMap.copyOf(bandSetup.getSynergies());
        this.licenses = MRVMLicense.createLicenses(this, licenseStartId, world.getRegionsMap());
    }

    public BigDecimal getSynergy(int quantity) {
        if (quantity < 0 || quantity > this.numberOfLots) {
            throw new IllegalArgumentException("Immpossible quantity");
        }
        if (quantity <= 1) {
            return BigDecimal.ONE;
        }
        BigDecimal synergy = this.synergies.get(quantity);
        if (synergy == null) {
            return this.getSynergy(quantity - 1);
        }
        return synergy;
    }

    public BigDecimal calculateCAP(int quantity) {
        return MRVMWorld.capOfBand(this, quantity);
    }

    public BigDecimal getBaseCapacity() {
        return this.baseCapacity;
    }

    @Override
    public MRVMWorld getWorld() {
        return this.world;
    }

    public List<MRVMLicense> containedGoods() {
        return Collections.unmodifiableList(this.licenses);
    }

    public int getNumberOfLots() {
        return this.numberOfLots;
    }

    @Override
    public int getQuantity() {
        return this.licenses.size();
    }

    @Override
    public long getWorldId() {
        return this.worldId;
    }

    private void setWorld(MRVMWorld world) {
        if (this.getWorldId() != world.getId()) {
            throw new IncompatibleWorldException("The stored worldId does not represent the passed world reference");
        }
        this.world = world;
    }

    public void refreshFieldBackReferences(MRVMWorld world) {
        this.setWorld(world);
        for (MRVMLicense license : this.licenses) {
            license.refreshFieldBackReferences(this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MRVMBand)) {
            return false;
        }
        MRVMBand other = (MRVMBand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BigDecimal this$baseCapacity = this.getBaseCapacity();
        BigDecimal other$baseCapacity = other.getBaseCapacity();
        if (this$baseCapacity == null ? other$baseCapacity != null : !((Object)this$baseCapacity).equals(other$baseCapacity)) {
            return false;
        }
        if (this.getNumberOfLots() != other.getNumberOfLots()) {
            return false;
        }
        List<MRVMLicense> this$licenses = this.licenses;
        List<MRVMLicense> other$licenses = other.licenses;
        if (this$licenses == null ? other$licenses != null : !((Object)this$licenses).equals(other$licenses)) {
            return false;
        }
        Map<Integer, BigDecimal> this$synergies = this.synergies;
        Map<Integer, BigDecimal> other$synergies = other.synergies;
        return !(this$synergies == null ? other$synergies != null : !((Object)this$synergies).equals(other$synergies));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MRVMBand;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BigDecimal $baseCapacity = this.getBaseCapacity();
        result = result * 59 + ($baseCapacity == null ? 43 : ((Object)$baseCapacity).hashCode());
        result = result * 59 + this.getNumberOfLots();
        List<MRVMLicense> $licenses = this.licenses;
        result = result * 59 + ($licenses == null ? 43 : ((Object)$licenses).hashCode());
        Map<Integer, BigDecimal> $synergies = this.synergies;
        result = result * 59 + ($synergies == null ? 43 : ((Object)$synergies).hashCode());
        return result;
    }
}

