/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;

public final class MRVMGenericDefinition
extends GenericGood {
    private final MRVMBand band;
    private final MRVMRegionsMap.Region region;
    private transient ImmutableList<MRVMLicense> licenses;

    public MRVMGenericDefinition(MRVMBand band, MRVMRegionsMap.Region region) {
        super("region: " + region.toString() + ", band: " + band.getName(), band.getWorldId());
        Preconditions.checkNotNull((Object)band);
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkArgument((boolean)band.getWorld().getRegionsMap().getRegions().contains(region));
        this.band = band;
        this.region = region;
    }

    @Override
    public MRVMWorld getWorld() {
        return this.band.getWorld();
    }

    public MRVMBand getBand() {
        return this.band;
    }

    public MRVMRegionsMap.Region getRegion() {
        return this.region;
    }

    public void checkQuantityIsValid(int quantity) {
        Preconditions.checkArgument((quantity >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((quantity <= this.band.getNumberOfLots() ? 1 : 0) != 0);
    }

    public List<MRVMLicense> containedGoods() {
        if (this.licenses == null) {
            ImmutableList.Builder licBuilder = new ImmutableList.Builder();
            for (MRVMLicense lic : this.band.containedGoods()) {
                if (!lic.getRegion().equals(this.region)) continue;
                licBuilder.add((Object)lic);
            }
            this.licenses = licBuilder.build();
        }
        return this.licenses;
    }

    @Override
    public JsonElement shortJson() {
        JsonObject json = new JsonObject();
        json.addProperty("band", this.band.getName());
        json.addProperty("region", (Number)this.region.getId());
        return json;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MRVMGenericDefinition)) {
            return false;
        }
        MRVMGenericDefinition other = (MRVMGenericDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MRVMBand this$band = this.getBand();
        MRVMBand other$band = other.getBand();
        if (this$band == null ? other$band != null : !((Object)this$band).equals(other$band)) {
            return false;
        }
        MRVMRegionsMap.Region this$region = this.getRegion();
        MRVMRegionsMap.Region other$region = other.getRegion();
        return !(this$region == null ? other$region != null : !((Object)this$region).equals(other$region));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MRVMGenericDefinition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        MRVMBand $band = this.getBand();
        result = result * 59 + ($band == null ? 43 : ((Object)$band).hashCode());
        MRVMRegionsMap.Region $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : ((Object)$region).hashCode());
        return result;
    }
}

