/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.util.List;
import java.util.stream.Collectors;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimitConstraint;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.mrvm.MRVMAllocationLimit;
import org.spectrumauctions.sats.core.model.mrvm.MRVMNationalBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;

public class MRVMNationalBidderAllocationLimit
extends MRVMAllocationLimit {
    public MRVMNationalBidderAllocationLimit(MRVMNationalBidder bidder) {
        super(bidder);
        for (MRVMRegionsMap.Region region : bidder.getWorld().getRegionsMap().getRegions()) {
            List<License> varLP = bidder.getWorld().getLicenses().stream().filter(l -> l.getRegion().equals(region)).filter(l -> l.getBandName().equals("LOW_PAIRED")).collect(Collectors.toList());
            List<License> varHP = bidder.getWorld().getLicenses().stream().filter(l -> l.getRegion().equals(region)).filter(l -> l.getBandName().equals("HIGH_PAIRED")).collect(Collectors.toList());
            String varName = "AgggregationLimitXhat_i=" + bidder.getId() + "_r=" + region.getId() + "b=LP";
            Variable hatVarLP = new Variable(varName, VarType.BOOLEAN, 0.0, 1.0);
            AllocationLimitConstraint upperLimitConstraint = new AllocationLimitConstraint(CompareType.LEQ, 0.0);
            upperLimitConstraint.addTerm(1.0, hatVarLP);
            this.addAll(upperLimitConstraint, -1.0, varLP);
            this.addAllocationLimitConstraint(upperLimitConstraint);
            AllocationLimitConstraint lowerLimitConstraint = new AllocationLimitConstraint(CompareType.GEQ, 0.0);
            lowerLimitConstraint.addTerm(1.0, hatVarLP);
            double coefficient = -1.0 / (double)varLP.size();
            this.addAll(lowerLimitConstraint, coefficient, varLP);
            this.addAllocationLimitConstraint(lowerLimitConstraint);
            varName = "AgggregationLimitXhat_i=" + bidder.getId() + "_r=" + region.getId() + "b=HP";
            Variable hatVarHP = new Variable(varName, VarType.BOOLEAN, 0.0, 1.0);
            upperLimitConstraint = new AllocationLimitConstraint(CompareType.LEQ, 0.0);
            upperLimitConstraint.addTerm(1.0, hatVarHP);
            this.addAll(upperLimitConstraint, -1.0, varHP);
            this.addAllocationLimitConstraint(upperLimitConstraint);
            lowerLimitConstraint = new AllocationLimitConstraint(CompareType.GEQ, 0.0);
            lowerLimitConstraint.addTerm(1.0, hatVarHP);
            coefficient = -1.0 / (double)varHP.size();
            this.addAll(lowerLimitConstraint, coefficient, varHP);
            this.addAllocationLimitConstraint(lowerLimitConstraint);
            AllocationLimitConstraint onlyOne = new AllocationLimitConstraint(CompareType.LEQ, 1.0);
            onlyOne.addTerm(1.0, hatVarHP);
            onlyOne.addTerm(1.0, hatVarLP);
            this.addAllocationLimitConstraint(onlyOne);
            AllocationLimitConstraint maxOneInHP = new AllocationLimitConstraint(CompareType.LEQ, 1.0);
            this.addAll(maxOneInHP, 1.0, varHP);
            this.addAllocationLimitConstraint(maxOneInHP);
        }
    }

    private void addAll(AllocationLimitConstraint constraint, double coefficient, List<License> licences) {
        licences.forEach(l -> constraint.addTerm(coefficient, (Good)l));
    }

    @Override
    public int calculateAllocationBundleSpace(List<? extends Good> startingSpace) {
        return Integer.MAX_VALUE;
    }
}

