/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimit;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionalBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.core.util.BigDecimalUtils;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;
import org.spectrumauctions.sats.opt.model.mrvm.MRVM_MIP;

public final class MRVMRegionalBidder
extends MRVMBidder {
    private static final long serialVersionUID = -3643980691138504665L;
    private final int homeId;
    transient MRVMRegionsMap.Region home;
    private final SortedMap<Integer, BigDecimal> distanceDiscounts;

    MRVMRegionalBidder(long id, long populationId, MRVMWorld world, MRVMRegionalBidderSetup setup, UniformDistributionRNG rng, AllocationLimit limit) {
        super(id, populationId, world, setup, rng, limit);
        this.home = setup.drawHome(world, rng);
        this.homeId = this.home.getId();
        this.distanceDiscounts = new TreeMap<Integer, BigDecimal>((SortedMap<Integer, BigDecimal>)setup.drawDistanceDiscounts(world, this.home, rng));
        this.validateDistanceDiscounts(this.getWorld(), this.distanceDiscounts);
        this.store();
    }

    private void validateDistanceDiscounts(MRVMWorld world, SortedMap<Integer, BigDecimal> discounts) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull(discounts);
        for (int i = 1; i < world.getRegionsMap().getLongestShortestPath(this.home); ++i) {
            Preconditions.checkNotNull((Object)((BigDecimal)discounts.get(i)));
            Preconditions.checkArgument((((BigDecimal)discounts.get(i)).compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (Object)"Discount must not be negative");
        }
    }

    public int getHomeId() {
        return this.homeId;
    }

    @Override
    public BigDecimal gammaFactor(MRVMRegionsMap.Region r, Set<MRVMLicense> bundle) {
        int distance = this.getWorld().getRegionsMap().getDistance(this.home, r);
        if (distance > this.distanceDiscounts.lastKey()) {
            return BigDecimal.ZERO;
        }
        return (BigDecimal)this.distanceDiscounts.get(distance);
    }

    @Override
    public Map<MRVMRegionsMap.Region, BigDecimal> gammaFactors(Set<MRVMLicense> bundle) {
        HashMap<MRVMRegionsMap.Region, BigDecimal> result = new HashMap<MRVMRegionsMap.Region, BigDecimal>();
        for (MRVMRegionsMap.Region region : this.getWorld().getRegionsMap().getRegions()) {
            int distance = this.getWorld().getRegionsMap().getDistance(this.home, region);
            BigDecimal discount = this.distanceDiscounts.getOrDefault(distance, BigDecimal.ZERO);
            result.put(region, discount);
        }
        return result;
    }

    @Override
    public MRVMRegionalBidder drawSimilarBidder(RNGSupplier rngSupplier) {
        return new MRVMRegionalBidder(this.getLongId(), this.getPopulation(), this.getWorld(), (MRVMRegionalBidderSetup)this.getSetup(), rngSupplier.getUniformDistributionRNG(), this.getAllocationLimit());
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> type, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
        return super.getValueFunction(type, rngSupplier);
    }

    @Override
    public void refreshReference(World world) {
        super.refreshReference(world);
        MRVMRegionsMap.Region homeCandidate = this.getWorld().getRegionsMap().getRegion(this.homeId);
        if (homeCandidate == null) {
            throw new IllegalArgumentException("The specified world does not have this bidders home region");
        }
        this.home = homeCandidate;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.distanceDiscounts == null ? 0 : BigDecimalUtils.hashCodeIgnoringScale(this.distanceDiscounts));
        result = 31 * result + this.homeId;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MRVMRegionalBidder other = (MRVMRegionalBidder)obj;
        if (this.distanceDiscounts == null ? other.distanceDiscounts != null : !BigDecimalUtils.equalIgnoreScaleOnValues(this.distanceDiscounts, other.distanceDiscounts)) {
            return false;
        }
        return this.homeId == other.homeId;
    }

    @Override
    protected void bidderTypeSpecificDemandQueryMIPAdjustments(MRVM_MIP mip) {
    }
}

